!define APPNAME "Akta gardena"
!define COMPANYNAME "IZFE"
!define DESCRIPTION "Audio aktak sortzeko tresna"

# set the name of the installer
!include "EnvVarUpdate.nsh"
Icon "Akta gardena.ico"
Outfile "AktaGardenaInstaller_x86_64.exe"

InstallDir "$PROGRAMFILES\Akta gardena\"

Caption "Akta gardena instaladorea"
UninstallCaption "Akta gardena desinstalatu"

Section -Prerequisites
 CreateDirectory "$PROGRAMFILES\Akta gardena"
 CreateDirectory "$PROGRAMFILES\Akta gardena\gstreamer"
  SetOutPath $INSTDIR\dependencies
  MessageBox MB_YESNO "Install GStreamer" /SD IDYES IDNO endGStreamer
    File "dependencies\gstreamer-1.0-x86_64-1.8.0.msi"
    ExecWait '"msiexec" INSTALLDIR="$PROGRAMFILES\Akta gardena\gstreamer" /i  "$INSTDIR\dependencies\gstreamer-1.0-x86_64-1.8.0.msi"'
    Goto endGStreamer
  endGStreamer:
  MessageBox MB_YESNO "Install K-lite codecs" /SD IDYES IDNO endKlite
    File "dependencies\K-Lite_Codec_Pack_1333_Basic.exe"
    ExecWait "$INSTDIR\dependencies\K-Lite_Codec_Pack_1333_Basic.exe"
    Goto endKlite
  endKlite:
  MessageBox MB_YESNO "Install Visual C redistributable package" /SD IDYES IDNO endVC
    File "dependencies\vc_redist.x64.exe"
    ExecWait "$INSTDIR\dependencies\vc_redist.x64.exe"
    Goto endVC
  endVC:
 
SectionEnd

Section -copy
writeUninstaller "$PROGRAMFILES\Akta gardena\uninstall.exe"

SetOutPath "$PROGRAMFILES\Akta gardena\"
File /nonfatal /a /r ".\app\"
SetOutPath "$PROGRAMFILES\Akta gardena\"
AccessControl::GrantOnFile "$PROGRAMFILES\Akta gardena"  "(BU)" "GenericRead + GenericWrite"

CreateDirectory "$SMPROGRAMS\Akta gardena\"
CreateShortCut "$DESKTOP\Akta gardena.lnk" "$PROGRAMFILES\Akta gardena\Akta gardena.exe" "Akta gardena"
CreateShortCut "$SMPROGRAMS\Akta gardena\Akta gardena.lnk" "$PROGRAMFILES\Akta gardena\Akta gardena.exe"
CreateShortCut "$SMPROGRAMS\Akta gardena\Desinstalatu.lnk" "$PROGRAMFILES\Akta gardena\uninstall.exe" "Desinstalatu"

# Start Menu
#CreateDirectory "$SMPROGRAMS\${APPNAME}"
#CreateShortCut "$SMPROGRAMS\${APPNAME}\${APPNAME}.lnk" "$INSTDIR\app\Akta gardena.exe" "" "$INSTDIR\Akta gardena.ico"

SectionEnd

Section "updatepath"
/*  ${EnvVarUpdate} $0 "PATH" "A" "HKCU" "$%GSTREAMER_1_0_ROOT_X86_64%" 
 ${EnvVarUpdate} $0 "PATH" "A" "HKCU" "$%GSTREAMER_1_0_ROOT_X86_64%lib\gstreamer-1.0" 
 ${EnvVarUpdate} $0 "PATH" "A" "HKCU" "$%GSTREAMER_1_0_ROOT_X86_64%bin\"  */
 ${EnvVarUpdate} $0 "PATH" "A" "HKCU" "$PROGRAMFILES\Akta gardena\gstreamer\1.0\x86_64\" 
 ${EnvVarUpdate} $0 "PATH" "A" "HKCU" "$PROGRAMFILES\Akta gardena\gstreamer\1.0\x86_64\lib\gstreamer-1.0\" 
 ${EnvVarUpdate} $0 "PATH" "A" "HKCU" "$PROGRAMFILES\Akta gardena\gstreamer\1.0\x86_64\bin\"
 
SectionEnd

Section "uninstall"
  # Remove Start Menu launcher
  delete "$DESKTOP\Akta gardena.lnk"
  RMDIR /r "$SMPrograms\Akta gardena\"
  RMDir /r "$PROGRAMFILES\Akta gardena\"
  
  # Remove Environmental Variables
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKCU" "$PROGRAMFILES\Akta gardena\gstreamer\1.0\x86_64\"
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKCU" "$PROGRAMFILES\Akta gardena\gstreamer\1.0\x86_64\lib\gstreamer-1.0\" 
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKCU" "$PROGRAMFILES\Akta gardena\gstreamer\1.0\x86_64\bin\"
SectionEnd
