#include "steps.h"

Steps::Steps(QObject *parent) : QObject(parent)
{

}

QHBoxLayout* Steps::getSteps(int step)
{
    QHBoxLayout *horizLayout=new QHBoxLayout();

    QStringList stepNames;
    stepNames << tr("1. Konfigurazioa") << tr("2. Grabazioa") << tr("3. Zuzendu eta baieztatu") << tr("4. Sinadura");
    QLabel *label;
    for(int i = 0; i <stepNames.size(); ++i){
        label = new QLabel();
        label->setMinimumHeight(45);
        label->setMaximumHeight(45);
        label->setText(stepNames.at(i));
        label->setAlignment(Qt::AlignVCenter | Qt::AlignLeft);
        if(i == step-1){
            label->setStyleSheet(QLatin1String("padding-left: 4px;border-image: url(:/images/fletxa-aktibo.png) 0 0 0 0 stretch stretch;"));
        }else{
            label->setStyleSheet(QLatin1String("padding-left: 4px;border-image: url(:/images/fletxa-desaktibo.png) 0 0 0 0 stretch stretch;"));
        }

        horizLayout->addWidget(label);
    }

    return horizLayout;
}
