#ifndef SIGNFORM_H
#define SIGNFORM_H

#include <QWidget>
#include <QDebug>
#include <QFileDialog>
#include <QKeyEvent>
#include <QMessageBox>
#include <QDesktopWidget>
#include <QDesktopServices>
#include <QListWidgetItem>
#include <QtNetwork>
#include <steps.h>
#include "dbmanager.h"
#include "izfesinadura.h"
#include "publikatu.h"
#include "nabigatzailea.h"
#include "lanean.h"
#include "item.h"
#include "atendee.h"
#include "log.h"
#include "funtzioak.h"

namespace Ui {
class SignForm;
}

class SignForm : public QWidget
{
    Q_OBJECT

public:
    explicit SignForm(int record_id, QWidget *parent = 0);
    ~SignForm();

private slots:
    void on_selectErabakiakButton_clicked();
    void on_selectFilesButton_clicked();

    void on_folderPathButton_clicked();

    void on_signErabakiakButton_clicked();

    void on_signAktaButton_clicked();

    void on_sinaduraEnd(QString egoera, QByteArray erantzuna);

    void on_amaituBotoia_clicked();

    void on_publikatuBotoia_clicked();

    void on_publikatuEnd();

    void on_sessionTypeCombo_currentIndexChanged(int index);

protected:
    bool eventFilter(QObject *obj, QEvent *ev);

private:
    Ui::SignForm *ui;

    QString sessionName;
    QString sessionType;
    QString shortDescription;
    QString dateTime;
    QString fileName;
    QString folderPath;
    QString egoera;

    QString erabakiakFile;
    QString acuerdosPDF = "acuerdos_adoptados.pdf"; // ahora tiene nombre fijo

    QString sinaduraZein;

    QStringList ezabatzekoFitxategiak;

    QSqlRelationalTableModel *sessionTypeModeloa;

    DbManager db;

    int recordId;

    Lanean *laneanWidget;

    bool isSigned (QString zein);
    void fitxategiakKonprobatu();
    void fitxategiakEzabatu();
    void writeLog();
    void aldaketakGorde();
    void sessionTypeSelect(int session_type_id, QString value);

    void resizeEvent(QResizeEvent* event);

    QPoint erdianKokatu (int zabalera, int altuera);
    QString sessionTypeName (int session_type_id, QString mota);
    void botoienLogika ();
    void showError(const QSqlError &err);

signals:
    void firstScreenSetCentralWidget();

};

#endif // SIGNFORM_H
