#include "signform.h"
#include "ui_signform.h"

SignForm::SignForm(int record_id, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::SignForm)
{
    ui->setupUi(this);
    ui->stepsLayout->addLayout(Steps::getSteps(4));
    ui->infoLayout->setAlignment(Qt::AlignTop);
    ui->filesList->installEventFilter(this);
    ui->sessionTypeCombo->blockSignals(true); // kargatu arte "on_sessionTypeCombo_currentIndexChanged" ez exekutatzeko

    this->laneanWidget = new Lanean(this);
    this->laneanWidget->hide();
    this->sinaduraZein = "";
    this->ezabatzekoFitxategiak = QStringList();

    if (db.isOpen()){
        QSqlQuery query;

        // Saio mota zerrenda kargatu
        this->sessionTypeModeloa = new QSqlRelationalTableModel(ui->sessionTypeCombo);
        this->sessionTypeModeloa->setTable("session_type");
        this->sessionTypeModeloa->setSort(this->sessionTypeModeloa->fieldIndex("id"), Qt::AscendingOrder);

        // Populate the model
        if (!this->sessionTypeModeloa->select()) {
            showError(this->sessionTypeModeloa->lastError());
            return;
        }

        ui->sessionTypeCombo->setModel(this->sessionTypeModeloa);

        if (QLocale().name().toStdString().compare("es_ES") == 0){
            ui->sessionTypeCombo->setModelColumn(this->sessionTypeModeloa->fieldIndex("izena_es"));
        }
        else{
            ui->sessionTypeCombo->setModelColumn(sessionTypeModeloa->fieldIndex("izena"));
        }

        // Erregistroa jaso
        query.prepare("SELECT * FROM record WHERE id=:recordId");
        query.bindValue(":recordId", record_id);
        query.exec();

        query.first();
        if (query.isValid()){
            this->recordId = record_id;
            this->sessionName = QLocale().name().toStdString().compare("es_ES") == 0 ? query.value("izena_es").toString() : query.value("izena").toString();
            this->sessionType = this->sessionTypeName(query.value("session_type_id").toInt(), query.value("mota").toString());
            this->shortDescription = query.value("deskribapena").toString();
            this->dateTime = query.value("data").toString();
            this->fileName = query.value("fileName").toString();
            this->folderPath = query.value("folderPath").toString();
            this->egoera = query.value("egoera").toString();
            this->erabakiakFile = query.value("erabakiakFile").toString();

            ui->dataValue->setText(this->dateTime);
            ui->izenaValue->setText(this->sessionName);
            ui->deskribapenaValue->setText(this->shortDescription);
            ui->erabakiakValue->setText("");

            this->sessionTypeSelect(query.value("session_type_id").toInt(), query.value("mota").toString());
            ui->sessionTypeCombo->blockSignals(false);

            /* FITXATEGIAK */
            ui->filesList->clear();

            QStringListIterator filesItr(query.value("files").toString().split("@@_@@"));
            while (filesItr.hasNext()){
                QString elem = filesItr.next();
                ui->filesList->addItem(elem);
            }

            this->fitxategiakKonprobatu();
        }
    }

    // Activamos los botones que corresponda
    this->botoienLogika();
}

SignForm::~SignForm()
{
}

void SignForm::on_selectErabakiakButton_clicked()
{
    QMessageBox msgBox;

    QString fileName = QFileDialog::getOpenFileName(this, tr("Select file"));
    if (!fileName.isEmpty()){
        QFileInfo txekFile(fileName);

        if (txekFile.exists() && txekFile.isFile()){
            QMimeDatabase mimeDb;
            QMimeType type = mimeDb.mimeTypeForFile(fileName);

            if (type.name().compare("application/pdf") == 0){
                ui->erabakiakValue->setText(fileName);

                this->aldaketakGorde();
            }
            else{
                msgBox.setText(tr("Erabakien dokumentua PDF bat izan behar du."));
                msgBox.setStandardButtons(QMessageBox::Ok);
                msgBox.setDefaultButton(QMessageBox::Ok);
                msgBox.exec();
            }
        }
    }
}

void SignForm::on_selectFilesButton_clicked()
{
    QStringList fileNames = QFileDialog::getOpenFileNames(this, tr("Select files"));
    QList<QListWidgetItem *> findItems;

    if (fileNames.count() > 0){
        for(int i = 0; i < fileNames.count(); ++i){
            findItems = ui->filesList->findItems(fileNames.at(i), Qt::MatchExactly);

            if(findItems.size() == 0)
                ui->filesList->addItem(fileNames.at(i));
        }

        this->aldaketakGorde();
    }
}

bool SignForm::eventFilter(QObject *object, QEvent *event)
{
    if (object == ui->filesList) {
        QListWidget *zerrenda = qobject_cast<QListWidget *>(object);

        if (event->type() == QEvent::KeyPress) {

            QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            switch(keyEvent->key()) {
                case Qt::Key_Delete:
                    // Los ficheros, como cualquier cambio, se borran cuando se pulsa el botón "Guardar".
                    // Hasta entonces los guardamos en una lista.
                    // Ya no es así, pero por no cambiar mucho dejo lo de la lista....
                    for (int i = 0; i < zerrenda->selectedItems().length(); i++)
                        this->ezabatzekoFitxategiak.append(zerrenda->selectedItems().at(i)->text());

                    qDeleteAll(zerrenda->selectedItems());

                    this->aldaketakGorde();
                break;
            }

            return true;

        }
        else {
            return false;
        }

    }
    else {
        return QWidget::eventFilter(object, event);
    }
}

void SignForm::aldaketakGorde()
{
    if (db.isOpen()){
        QSqlQuery query;

        // Erabakien fitxategia
        if (!ui->erabakiakValue->text().isEmpty()){
            QFileInfo txekFile(ui->erabakiakValue->text());
            if (txekFile.exists() && txekFile.isFile()){
                // fitxategia aldatu bada --> aurrekoa ezabatu eta berria direktoriora ekarri
                if (this->erabakiakFile.compare(ui->erabakiakValue->text()) != 0){
                    if (!this->erabakiakFile.isEmpty())
                        QFile::remove(this->erabakiakFile);

                    this->erabakiakFile = "";

                    QString erabakiakFileName = this->acuerdosPDF;
                    if (QFile::copy(ui->erabakiakValue->text(), this->folderPath + "/" + erabakiakFileName)){
                        this->erabakiakFile = this->folderPath + "/" + erabakiakFileName;
                        ui->erabakiakValue->setText(this->erabakiakFile);
                    }
                    else{
                        qDebug() << "Errorea fitxategia kopiatzerakoan (" + this->acuerdosPDF + ")";
                    }

                    query.prepare("UPDATE record SET erabakiakFile=:erabakiakFile WHERE id=:recordId");
                    query.bindValue(":erabakiakFile", this->erabakiakFile);
                    query.bindValue(":recordId", this->recordId);
                    query.exec();
                }
            }
        }

        // Fitxategiak
        this->fitxategiakEzabatu();
        this->fitxategiakKonprobatu();

        // Activamos los botones que corresponda
        this->botoienLogika();
    }
}

void SignForm::on_folderPathButton_clicked()
{
    QDesktopServices::openUrl(QUrl("file:///" + this->folderPath));
}

void SignForm::on_signErabakiakButton_clicked()
{
    QMessageBox msgBox;

    // Comprobamos que exista el fichero
    QFileInfo txekFile(this->erabakiakFile);
    if (txekFile.exists() && txekFile.isFile()){
        //this->laneanWidget->resize(this->size());
        this->laneanWidget->show();

        this->sinaduraZein = "erabakiak";

        izfeSinadura *sinadura = new izfeSinadura();
        sinadura->sendRequest(this->erabakiakFile);

        connect(sinadura, SIGNAL(sinaduraEnd(QString, QByteArray)), this, SLOT(on_sinaduraEnd(QString, QByteArray)));
    }
    else{
        this->erabakiakFile = "";
        ui->erabakiakValue->setText("");

        // Activamos los botones que corresponda
        this->botoienLogika();

        msgBox.setText(tr("Dokumentua ez da existitzen."));
        msgBox.setStandardButtons(QMessageBox::Ok);
        msgBox.setDefaultButton(QMessageBox::Ok);
        msgBox.exec();
    }
}

void SignForm::on_signAktaButton_clicked()
{
    QMessageBox msgBox;

    // Comprobamos que exista el fichero
    QFileInfo txekFile(this->folderPath + "/" + this->fileName + ".xml");
    if (txekFile.exists() && txekFile.isFile()){
        //this->laneanWidget->resize(this->size());
        this->laneanWidget->show();

        this->sinaduraZein = "akta";

        // Volvemos a crear el XML con los ficheros adicionales
        this->writeLog();

        izfeSinadura *sinadura = new izfeSinadura();
        sinadura->sendRequest(this->folderPath + "/" + this->fileName + ".xml");

        connect(sinadura, SIGNAL(sinaduraEnd(QString, QByteArray)), this, SLOT(on_sinaduraEnd(QString, QByteArray)));
    }
    else{
        // Activamos los botones que corresponda
        this->botoienLogika();

        msgBox.setText(tr("Dokumentua ez da existitzen."));
        msgBox.setStandardButtons(QMessageBox::Ok);
        msgBox.setDefaultButton(QMessageBox::Ok);
        msgBox.exec();
    }
}

void SignForm::on_sinaduraEnd(QString egoera, QByteArray erantzuna)
{
    QMessageBox msgBox;

    if (egoera.compare("ok") == 0){
        QFile file(this->folderPath + "/" + Funtzioak::getSignedFileName(this->recordId, this->sinaduraZein));
        if (file.open(QIODevice::WriteOnly | QIODevice::Unbuffered)){
            file.write(erantzuna);
            file.close();

            // Activamos los botones que corresponda
            this->botoienLogika();

            // Cambiamos la egoera del record
            if (this->egoera.compare("sign") != 0 && db.isOpen()){
                QSqlQuery query;
                query.prepare("UPDATE record SET egoera='sign' WHERE id=:recordId");
                query.bindValue(":recordId", this->recordId);
                query.exec();
            }

            msgBox.setText(tr("Dokumentua sinatuta!"));
            msgBox.setStandardButtons(QMessageBox::Ok);
            msgBox.setDefaultButton(QMessageBox::Ok);
            msgBox.exec();

            this->laneanWidget->close();

            return;
        }
        else
            erantzuna = "Errorea sinaduraren fitxategia sortzerakoan";
    }

    // Si llegamos hasta aquí es que algo ha ido mal, no se ha generado la firma.
    msgBox.setText(tr("Ezin izan da dokumentua sinatu. Pixka batean egon eta berriro saiatu.")  +" (" + erantzuna + ")");
    msgBox.setStandardButtons(QMessageBox::Ok);
    msgBox.setDefaultButton(QMessageBox::Ok);
    msgBox.exec();

    this->laneanWidget->close();
}

bool SignForm::isSigned (QString zein)
{
    QFileInfo txekFile(this->folderPath + "/" + Funtzioak::getSignedFileName(this->recordId, zein));

    return (txekFile.exists() && txekFile.isFile());
}

void SignForm::fitxategiakKonprobatu ()
{
    QString file;
    QStringList files;
    QFileInfo txekFile;

    for (int i = 0; i < ui->filesList->count(); i++){
        file = ui->filesList->item(i)->text();

        txekFile = QFileInfo(file);
        if (txekFile.exists() && txekFile.isFile()){
            if (txekFile.absolutePath().compare(this->folderPath) != 0){

                if (QFile::copy(file, this->folderPath + "/" + txekFile.fileName()))
                    files.append(this->folderPath + "/" + txekFile.fileName());

            }
            else
                files.append(file);
        }
    }

    // Datu basea eguneratu (porsiaka)
    if (db.isOpen()){
        QSqlQuery query;
        query.prepare("UPDATE record SET files=:files WHERE id=:recordId");
        query.bindValue(":files", files.join("@@_@@"));
        query.bindValue(":recordId", this->recordId);
        query.exec();
    }

    // Lista eguneratu
    ui->filesList->clear();
    for (int i = 0; i < files.length(); i++)
        ui->filesList->addItem(files.at(i).toLocal8Bit().constData());
}

void SignForm::fitxategiakEzabatu()
{
    QString file;
    QFileInfo txekFile;

    for (int i = 0; i < this->ezabatzekoFitxategiak.length(); i++){
        file = this->ezabatzekoFitxategiak.at(i).toLocal8Bit().constData();

        txekFile = QFileInfo(file);
        if (txekFile.exists() && txekFile.isFile()){
            if (txekFile.absolutePath().compare(this->folderPath) == 0){
                QFile f(file);
                f.remove();
            }
        }
    }

    this->ezabatzekoFitxategiak = QStringList();
}

void SignForm::writeLog()
{
    QList<Atendee> *extendedAtendees =new QList<Atendee>();
    QList<Item> *extendedItems = new QList<Item>();
    QList<Item> extendedItemList;
    QList<Atendee> extendedAtendeeList;

    /* Parte hartzaileak eta gaiak kargatu */
    Log *readLog = new Log();
    readLog->readLog(this->folderPath + "/" + this->fileName + ".xml", extendedItems, extendedAtendees);

    /// Initialize Items
    QListIterator<Item> extendedItemIterator(*extendedItems);
    while(extendedItemIterator.hasNext()){
        extendedItemList.append(extendedItemIterator.next());
    }

    /// Initialize Atendees
    QListIterator<Atendee> extendedAtendeeIterator(*extendedAtendees);
    while(extendedAtendeeIterator.hasNext()){
        extendedAtendeeList.append(extendedAtendeeIterator.next());
    }

    /* Log fitxategia berriz sortu, oraingoan fitxategi gehigarriekin */
    Log *writeLog = new Log();
    writeLog->InitLog(this->recordId);

    QListIterator<Atendee> atendeeIterator(extendedAtendeeList);
    while(atendeeIterator.hasNext())
    {
        Atendee currentAtendee=atendeeIterator.next();
        writeLog->SaveLogMessage(0,currentAtendee.getName(),currentAtendee.getInitTime(),currentAtendee.getEndTime());
    }

    QListIterator<Item> itemIterator(extendedItemList);
    while(itemIterator.hasNext())
    {
        Item currentItem=itemIterator.next();
        writeLog->SaveLogMessage(1,currentItem.getName(),currentItem.getInitTime(),currentItem.getEndTime(),currentItem.getId());
    }

    writeLog->CloseLog(this->recordId, true);
}

void SignForm::resizeEvent(QResizeEvent* event)
{
    this->laneanWidget->resize(this->size());
}

void SignForm::on_amaituBotoia_clicked()
{
    emit firstScreenSetCentralWidget();
}

void SignForm::on_publikatuBotoia_clicked()
{
    QMessageBox msgBox;

    // Comprobamos que existan acta y acuerdos
    QFileInfo txekFileActa(this->folderPath + "/" + this->fileName + ".xml");
    QFileInfo txekFileAcuerdos(this->erabakiakFile);
    if (txekFileActa.exists() && txekFileActa.isFile() &&
        txekFileAcuerdos.exists() && txekFileAcuerdos.isFile()){

        Publikatu *publikatuWidget = new Publikatu(this->recordId, this);
        publikatuWidget->setAttribute(Qt::WA_DeleteOnClose);
        publikatuWidget->setWindowModality(Qt::ApplicationModal);
        publikatuWidget->setWindowFlags(Qt::Window | Qt::WindowTitleHint);

        // Centramos la ventana
        publikatuWidget->move(erdianKokatu(publikatuWidget->width(), publikatuWidget->height()));

        // Mostramos la ventana
        publikatuWidget->show();

        connect(publikatuWidget, SIGNAL(publikatuEnd()), this, SLOT(on_publikatuEnd()));
    }
    else{
        // Activamos los botones que corresponda
        this->botoienLogika();

        msgBox.setText(tr("Dokumentua ez da existitzen."));
        msgBox.setStandardButtons(QMessageBox::Ok);
        msgBox.setDefaultButton(QMessageBox::Ok);
        msgBox.exec();
    }
}

QPoint SignForm::erdianKokatu (int zabalera, int altuera)
{
    QPoint puntu;

    /* Aplikazioaren erdian kokatzeko */
    puntu.setX(this->mapToGlobal(this->pos()).x() + ((this->width() - zabalera) / 2));
    puntu.setY(this->mapToGlobal(this->pos()).y() + ((this->height() - altuera) / 2));

    return (puntu);
}

QString SignForm::sessionTypeName (int session_type_id, QString mota)
{
    QString izena = mota;

    if (db.isOpen()){
        QSqlQuery query;

        query.prepare("SELECT * FROM session_type WHERE id=:session_type_id");
        query.bindValue(":session_type_id", session_type_id);
        query.exec();

        query.first();
        if (query.isValid()){

            izena = QLocale().name().toStdString().compare("es_ES") == 0 ? query.value("izena_es").toString() : query.value("izena").toString();
        }
    }

    return (izena);
}

void SignForm::botoienLogika ()
{
    // Orden de las cosas:
    // 1. Elegir archivo de acuerdos
    // 2. Firmar archico de acuerdos
    // 3. Firmar acta
    // 4. Publicar

    QFileInfo txekFile;

    // De momento desactivamos todo
    ui->signErabakiakButton->setDisabled(true);
    ui->selectErabakiakButton->setDisabled(true);
    ui->signAktaButton->setDisabled(true);
    ui->selectFilesButton->setDisabled(true);
    ui->filesList->setDisabled(true);
    ui->publikatuBotoia->setDisabled(true);
    ui->sessionTypeCombo->setDisabled(true);

    // Si está publicado se acabó, no activamos nada.
    txekFile = QFileInfo(this->folderPath + "/.publikatuta");
    if (!txekFile.exists()){

        // ¿Hay fichero de acuerdos?
        txekFile = QFileInfo(this->erabakiakFile);
        if (txekFile.exists() && txekFile.isFile()){
            ui->erabakiakValue->setText(this->acuerdosPDF);

            // ¿Están firmados los acuerdos?
            if (this->isSigned("erabakiak")){

                // ¿Está firmada el acta?
                if (this->isSigned("akta")){
                    ui->publikatuBotoia->setDisabled(false);
                }
                else{
                    ui->signAktaButton->setDisabled(false);
                    ui->selectFilesButton->setDisabled(false);
                    ui->filesList->setDisabled(false);
                    ui->sessionTypeCombo->setDisabled(false);
                }

            }
            else{
                ui->signErabakiakButton->setDisabled(false);
                ui->selectErabakiakButton->setDisabled(false);
                ui->selectFilesButton->setDisabled(false);
                ui->filesList->setDisabled(false);
                ui->sessionTypeCombo->setDisabled(false);
            }

        }
        else{
            ui->selectErabakiakButton->setDisabled(false);
            ui->selectFilesButton->setDisabled(false);
            ui->filesList->setDisabled(false);
            ui->sessionTypeCombo->setDisabled(false);
        }

    }
}

void SignForm::on_publikatuEnd()
{
    this->botoienLogika();
}

void SignForm::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}

void SignForm::sessionTypeSelect(int session_type_id, QString value)
{
    // ID-a bilatu
    for (int i=0; i < this->sessionTypeModeloa->rowCount(); i++){
        if (this->sessionTypeModeloa->data(sessionTypeModeloa->index(i, this->sessionTypeModeloa->fieldIndex("id"))).toInt() == session_type_id){
            ui->sessionTypeCombo->setCurrentIndex(i);
            return;
        }
    }

    // value-a bilatu (por retrocompatibilidad absurda)
    for (int i=0; i < this->sessionTypeModeloa->rowCount(); i++){
        if (ui->sessionTypeCombo->itemText(i) == value){
            ui->sessionTypeCombo->setCurrentIndex(i);
            return;
        }
    }

    // Seleccionamos el primer elemento (no se ha encontrado "value")
    ui->sessionTypeCombo->setCurrentIndex(0);
}

void SignForm::on_sessionTypeCombo_currentIndexChanged(int index)
{
    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("Konfirmazioa"));
    msgBox.setText(tr("Aldaketa gordetzea nahi duzu?"));
    msgBox.setIcon(QMessageBox::Question);
    msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
    msgBox.setDefaultButton(QMessageBox::Cancel);
    int ret = msgBox.exec();

    switch (ret) {
      case QMessageBox::Ok:
        if (db.isOpen()){
            QSqlQuery query;

            query.prepare("UPDATE record SET mota=:mota, session_type_id=:session_type_id WHERE id=:recordId");
            query.bindValue(":mota", ui->sessionTypeCombo->itemText(index));
            query.bindValue(":session_type_id", this->sessionTypeModeloa->data(this->sessionTypeModeloa->index(index, this->sessionTypeModeloa->fieldIndex("id"))).toInt());
            query.bindValue(":recordId", this->recordId);
            query.exec();
        }

        break;
    }
}
