#include "settingsvideo.h"
#include "ui_settingsvideo.h"

settingsVideo::settingsVideo(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::settingsVideo)
{
    ui->setupUi(this);

    setWindowTitle(tr("Bideo ezarpenak"));

    setFixedSize (220, 175);

    QSettings settings("bideoakta", "iametza");
    if (!settings.contains("bideo_iturria_index")){
        // Guardamos los valores por defecto en "settings"
        settings.setValue("bideo_iturria_index", 2);
        settings.setValue("bideo_iturria_text", ui->videoSourceComboBox->itemText(2));
        ui->videoSourceComboBox->setCurrentIndex(2);

        settings.setValue("bideo_formatua_index", ui->inputModeComboBox->currentIndex());
        settings.setValue("bideo_formatua_text", ui->inputModeComboBox->itemText(ui->inputModeComboBox->currentIndex()));
    }
    else{
        // Asignamos a los combos el valor guardado en "settings" (comprobando que exista)
        int index = settings.value("bideo_iturria_index").toInt();

        if (index < ui->videoSourceComboBox->count()){
            ui->videoSourceComboBox->setCurrentIndex(index);
        }
        else{
            // Modificamos los valores en "settings"
            settings.setValue("bideo_iturria_index", ui->videoSourceComboBox->currentIndex());
            settings.setValue("bideo_iturria_text", ui->videoSourceComboBox->itemText(ui->videoSourceComboBox->currentIndex()));
        }

        index = settings.value("bideo_formatua_index").toInt();

        if (index < ui->inputModeComboBox->count()){
            ui->inputModeComboBox->setCurrentIndex(index);
        }
        else{
            // Modificamos los valores en "settings"
            settings.setValue("bideo_formatua_index", ui->inputModeComboBox->currentIndex());
            settings.setValue("bideo_formatua_text", ui->inputModeComboBox->itemText(ui->inputModeComboBox->currentIndex()));
        }
    }
}

settingsVideo::~settingsVideo()
{
    delete ui;
}

void settingsVideo::on_cancelBotoia_clicked()
{
    close ();
}

void settingsVideo::on_okBotoia_clicked()
{
    QSettings settings("bideoakta", "iametza");
    settings.setValue("bideo_iturria_index", ui->videoSourceComboBox->currentIndex());
    settings.setValue("bideo_iturria_text", ui->videoSourceComboBox->itemText(ui->videoSourceComboBox->currentIndex()));

    settings.setValue("bideo_formatua_index", ui->inputModeComboBox->currentIndex());
    settings.setValue("bideo_formatua_text", ui->inputModeComboBox->itemText(ui->inputModeComboBox->currentIndex()));

    close ();
}

void settingsVideo::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close ();
}

void settingsVideo::on_videoSourceComboBox_currentIndexChanged(int index)
{
    ui->inputModeComboBox->setEnabled(index != 2);
}
