#include "settingsaudio.h"
#include "ui_settingsaudio.h"

settingsAudio::settingsAudio(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::settingsAudio)
{
    ui->setupUi(this);

    setWindowTitle(tr("Audio ezarpenak"));

    setFixedSize (300, 140);

    QSettings settings("bideoakta", "iametza");
    if (!settings.contains("audio_iturria_index")){
        // Guardamos los valores por defecto en "settings"
        settings.setValue("audio_iturria_index", ui->audioSourceComboBox->currentIndex());
        settings.setValue("audio_iturria_text", ui->audioSourceComboBox->itemText(ui->audioSourceComboBox->currentIndex()));
    }
    else{
        // Asignamos al combo el valor guardado en "settings" (comprobando que exista)
        int index = settings.value("audio_iturria_index").toInt();

        if (index < ui->audioSourceComboBox->count()){
            ui->audioSourceComboBox->setCurrentIndex(index);
        }
        else{
            // Modificamos los valores en "settings"
            settings.setValue("audio_iturria_index", ui->audioSourceComboBox->currentIndex());
            settings.setValue("audio_iturria_text", ui->audioSourceComboBox->itemText(ui->audioSourceComboBox->currentIndex()));
        }
    }
}

settingsAudio::~settingsAudio()
{
    delete ui;
}

void settingsAudio::on_cancelBotoia_clicked()
{
    close ();
}

void settingsAudio::on_okBotoia_clicked()
{
    QSettings settings("bideoakta", "iametza");
    settings.setValue("audio_iturria_index", ui->audioSourceComboBox->currentIndex());
    settings.setValue("audio_iturria_text", ui->audioSourceComboBox->itemText(ui->audioSourceComboBox->currentIndex()));

    close ();
}

void settingsAudio::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close ();
}
