#ifndef SELECTTHEME_H
#define SELECTTHEME_H

#include <QWidget>
#include <QDebug>
#include <QtSql>
#include <QMessageBox>
#include <QListWidgetItem>
#include <QKeyEvent>

#include "dbmanager.h"

namespace Ui {
class selectTheme;
}

class selectTheme : public QWidget
{
    Q_OBJECT

public:
    explicit selectTheme(QWidget *parent = 0);
    ~selectTheme();

private slots:
    void on_cancelBotoia_clicked();

    void on_okBotoia_clicked();

    void on_zerrenda_itemClicked(QListWidgetItem *item);

private:
    Ui::selectTheme *ui;

    DbManager db;

    void keyPressEvent(QKeyEvent *keyEvent);
    void showError(const QSqlError &err);

signals:
    void themesKargatu(QList<QString> zerrenda);

};

#endif // SELECTTHEME_H
