#include "selecttheme.h"
#include "ui_selecttheme.h"

selectTheme::selectTheme(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::selectTheme)
{
    ui->setupUi(this);

    if (db.isOpen()){
        ui->zerrenda->clear();

        QSqlQuery query;
        QString izena = QLocale().name().toStdString().compare("es_ES") == 0 ? "izena_es" : "izena";
        query.prepare("SELECT id, " + izena + " FROM theme");
        query.exec();
        while(query.next()){
            QListWidgetItem* item = new QListWidgetItem(query.value(izena).toString(), ui->zerrenda);
            item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
            item->setCheckState(Qt::Unchecked);

            QVariant id;
            id.setValue(query.value("id").toInt());
            item->setData(Qt::UserRole, id);
        }
    }

    ui->zerrenda->sortItems(Qt::AscendingOrder);

    setWindowTitle(tr("Load Theme"));

    setFixedSize (232, 302);
}

selectTheme::~selectTheme()
{
    delete ui;
}

void selectTheme::on_cancelBotoia_clicked()
{
    close();
}

void selectTheme::on_okBotoia_clicked()
{
    QList<QString> zerrenda;

    QListWidgetItem* item = 0;
    for(int i = 0; i < ui->zerrenda->count(); ++i){
        item = ui->zerrenda->item(i);

        if (item->checkState() == Qt::Checked){
            QVariant id = item->data(Qt::UserRole);

            zerrenda.push_back(id.toString() + "##_##" + item->text());
        }
    }

    emit themesKargatu(zerrenda);

    close();
}

void selectTheme::on_zerrenda_itemClicked(QListWidgetItem *item)
{
    item->setCheckState(item->checkState() ? Qt::Unchecked : Qt::Checked);
}

void selectTheme::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close();
}

void selectTheme::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}
