#include "selectrecord.h"
#include "ui_selectrecord.h"

selectRecord::selectRecord(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::selectRecord)
{
    ui->setupUi(this);

    if (db.isOpen()){
        modeloa = new QSqlRelationalTableModel(ui->zerrenda);
        modeloa->setEditStrategy(QSqlTableModel::OnManualSubmit);
        modeloa->setTable("record");

        modeloa->setHeaderData(modeloa->fieldIndex("data"), Qt::Horizontal, tr("Data"));
        modeloa->setHeaderData(modeloa->fieldIndex("izena"), Qt::Horizontal, tr("Session Name"));
        modeloa->setHeaderData(modeloa->fieldIndex("mota"), Qt::Horizontal, tr("Session Type"));
        modeloa->setHeaderData(modeloa->fieldIndex("egoera"), Qt::Horizontal, tr("Egoera"));
        modeloa->setHeaderData(modeloa->fieldIndex("izena_es"), Qt::Horizontal, tr("Session Name"));

        // Populate the model
        if (!modeloa->select()) {
            showError(modeloa->lastError());
            return;
        }

        ui->zerrenda->setModel(modeloa);

        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("id"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("deskribapena"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("folderPath"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("fileName"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("audioVideo"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("atendees"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("themes"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("files"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("erabakiakFile"), true);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("session_type_id"), true);

        if (QLocale().name().toStdString().compare("es_ES") == 0){
            ui->zerrenda->setColumnHidden(modeloa->fieldIndex("izena"), true);
            ui->zerrenda->horizontalHeader()->moveSection(14, 2);
            ui->zerrenda->horizontalHeader()->setSectionResizeMode(14, QHeaderView::Stretch);
        }
        else{
            ui->zerrenda->setColumnHidden(modeloa->fieldIndex("izena_es"), true);
            ui->zerrenda->horizontalHeader()->setSectionResizeMode(2, QHeaderView::Stretch);
        }

        ui->zerrenda->setColumnWidth(1, 150);
        ui->zerrenda->setColumnWidth(3, 200);
        //ui->zerrenda->horizontalHeader()->setStretchLastSection(true);
        ui->zerrenda->setSortingEnabled(true);
        ui->zerrenda->sortByColumn(1, Qt::DescendingOrder);
        ui->zerrenda->setEditTriggers(QAbstractItemView::NoEditTriggers);
        ui->zerrenda->setSelectionBehavior(QAbstractItemView::SelectRows);
        ui->zerrenda->installEventFilter(this);
    }
}

selectRecord::~selectRecord()
{
    delete ui;
}

void selectRecord::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}

void selectRecord::on_zerrenda_doubleClicked(const QModelIndex &index)
{
    //record(id, data, izena, mota, deskribapena, folderPath, fileName, audioVideo, atendees, themes, egoera)

    QString egoera = modeloa->index(index.row(), 10).data().toString();
    int record_id = modeloa->index(index.row(), 0).data().toInt();

    if (egoera == "config"){

        emit configuratorSetCentralWidget(record_id);

    }
    else if (egoera == "verify"){

        emit mediaAppSetCentralWidget(record_id);

    }
    else if (egoera == "sign"){

        emit signFormSetCentralWidget(record_id);

    }
}

void selectRecord::on_ezabatuBotoia_clicked()
{
    QItemSelection selection(ui->zerrenda->selectionModel()->selection());

    QList<int> rows;
    foreach (const QModelIndex & index, selection.indexes()){
        rows.append (index.row());
    }

    qSort (rows);

    if (rows.count() > 0){
        QMessageBox msgBox;
        msgBox.setWindowTitle(tr("Konfirmazioa"));
        msgBox.setText(tr("Ezabatzea aukeratu duzu. Ziur al zaude?"));
        msgBox.setIcon(QMessageBox::Question);
        msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        msgBox.setDefaultButton(QMessageBox::Cancel);
        int ret = msgBox.exec();

        QStringList formatuak;
        formatuak << ".xml" << ".mp3" << ".mp4";

        QStringListIterator formatuakItr(formatuak);
        QString folderPath, fileName, formatua;
        QFile file;

        switch (ret) {
          case QMessageBox::Ok:
            int prev = -1;
            for (int i = rows.count() - 1; i >= 0; i -= 1 ){
                int current = rows[i];
                if (current != prev){
                    /*folderPath = modeloa->index(current, 5).data().toString();
                    fileName = modeloa->index(current, 6).data().toString();

                    while (formatuakItr.hasNext()){
                        formatua = formatuakItr.next();

                        file.setFileName(folderPath + "/" + fileName + formatua);
                        if (file.exists())
                            file.remove();
                    }

                    formatuakItr.toFront();*/

                    // Oharrak ezabatu
                    if (db.isOpen()){
                        QSqlQuery query;
                        query.prepare("DELETE FROM record_notes WHERE record_id=:record_id");
                        query.bindValue(":record_id", modeloa->index(current, 0).data().toInt());
                        query.exec();
                    }

                    modeloa->removeRows(current, 1);
                    prev = current;
                }
            }

            if (rows.count() > 0){
                modeloa->submitAll();

                if (!modeloa->select()) {
                    showError(modeloa->lastError());
                    return;
                }
            }

            break;
        }
    }
}

bool selectRecord::eventFilter(QObject *object, QEvent *event)
{
    if (object == ui->zerrenda) {

        if (event->type() == QEvent::KeyPress) {

            QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            switch(keyEvent->key()) {
                case Qt::Key_Delete:
                    on_ezabatuBotoia_clicked();
                    break;
            }

            return true;

        }
        else {
            return false;
        }

    }
    else {
        return QWidget::eventFilter(object, event);
    }
}
