#include "selectatendee.h"
#include "ui_selectatendee.h"

selectAtendee::selectAtendee(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::selectAtendee)
{
    ui->setupUi(this);

    if (db.isOpen()){
        ui->zerrenda->clear();

        QSqlQuery query;
        query.prepare("SELECT izena FROM atendee");
        query.exec();
        while(query.next()){
            QListWidgetItem* item = new QListWidgetItem(query.value("izena").toString(), ui->zerrenda);
            //item->setFlags(item->flags() | Qt::ItemIsUserCheckable);
            item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
            item->setCheckState(Qt::Unchecked);
        }
    }

    ui->zerrenda->sortItems(Qt::AscendingOrder);

    setWindowTitle(tr("Load Atendee"));

    setFixedSize (232, 302);
}

selectAtendee::~selectAtendee()
{
    delete ui;
}

void selectAtendee::on_cancelBotoia_clicked()
{
    close();
}

void selectAtendee::on_okBotoia_clicked()
{
    QList<QString> zerrenda;

    QListWidgetItem* item = 0;
    for(int i = 0; i < ui->zerrenda->count(); ++i){
        item = ui->zerrenda->item(i);

        if (item->checkState() == Qt::Checked)
            zerrenda.push_back(item->text());
    }

    emit atendeesKargatu(zerrenda);

    close();
}

void selectAtendee::on_zerrenda_itemClicked(QListWidgetItem *item)
{
    item->setCheckState(item->checkState() ? Qt::Unchecked : Qt::Checked);
}

void selectAtendee::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close();
}

void selectAtendee::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}
