#ifndef RECORDER_H
#define RECORDER_H

#include "ui_recorder.h"

#include <QWidget>
#include <QDir>
#include <QApplication>
#include <QMessageBox>
#include <QStringList>
#include <QtDebug>
#include <QSettings>
#include <QGstStream.h>
#include <QDate>
#include <QtSql>
#include <QDesktopWidget>
#include "log.h"
#include "atendee.h"
#include "item.h"
#include "videoplayer.h"
#include "dbmanager.h"
#include "steps.h"
#include "selecttheme.h"
#include "selectatendee.h"
#include "funtzioak.h"

#define logfilename "/tmp/log.xml"

namespace Ui {
class Recorder;
}

class Recorder : public QWidget
{
    Q_OBJECT
public:
    explicit Recorder(int record_id, QWidget *parent = 0);
    ~Recorder();
private:
    enum Device { AudioSrc, VideoSrc };

    /*QGst::BinPtr createAudioSrcBin();
    QGst::BinPtr createOnlyAudioSrcBin();
    QGst::BinPtr createVideoSrcBin();

    void start();
    void stop();

    void onBusMessage(const QGst::MessagePtr & message);*/

    void loadAtendees();
    void loadItems();
    void initSpeaking(QString speaker);
    void endSpeaking(QString speaker);
    void initItem(QString item);
    void endItem(QString item);
    void start();
    void stop();
    void pause();
    void resume();

    QString getRecordingTime();

    void writeSpeakerSpeaking(QString speaker,QString initTime,QString endTime);
    void writeItem(QString id, QString item,QString initTime,QString endTime);

private Q_SLOTS:
    void on_startStopButton_clicked();
    void atendeeSelected(bool checked);
    void itemSelected(bool checked);
    void on_verifyPushButton_clicked();
    void showTime();
    void show_dB();
    void on_pauseButton_clicked();

    void on_gehituNoteBotoia_clicked();

    void on_noteTestua_returnPressed();

    void on_itemGehituBotoia_clicked();
    void on_themesKargatu(QList<QString> zerrenda);

    void on_atendeeGehituBotoia_clicked();
    void on_atendeesKargatu(QList<QString> zerrenda);

private:
    Ui::Recorder m_ui;
    //QGst::PipelinePtr m_pipeline;
    bool started;
    bool paused;
    Log log;

    QGstStream *stream;

    QStringList currentAtendees;
    QStringList currentItems;
    QStringList currentFiles;
    QList<Atendee> atendeesList;
    QList<Item> itemList;
    QString sessionName;
    QString sessionType;
    QString shortDescription;
    QString dateTime;
    QString fileName;
    QString folderPath;
    QString offsetTime;
    void importAtendees(QStringList atendees);
    void importItems(QStringList items);
    void printAtendeeList();
    bool audioVideo;//audio=false,video=true

    QPushButton *itemActiveButton, *atendeeActiveButton;

    DbManager db;

    int recordId;
    int itemKopurua, atendeeKopurua;

    selectTheme *selectThemeWidget;
    selectAtendee *selectAtendeeWidget;

    void setItemButtons(bool enabled);
    void setAtendeeButtons(bool enabled);
    void deselectAll();
    void setOtherThemes(QString activeThemeName, bool activeThemeEnabled);
    QPoint erdianKokatu (int zabalera, int altuera);
signals:
    void mediaAppSetCentralWidget(int record_id);
};
#endif // RECORDER_H
