#ifndef PUBLIKATU_H
#define PUBLIKATU_H

#include <QWidget>
#include <QHash>
#include <QFtp>
#include "dbmanager.h"
#include "funtzioak.h"

namespace Ui {
class Publikatu;
}

class Publikatu : public QWidget
{
    Q_OBJECT

public:
    explicit Publikatu(int record_id, QWidget *parent = 0);
    ~Publikatu();

signals:
    void publikatuEnd();

private slots:
    void on_itxiBotoia_clicked();
    void ftpCommandFinished(int commandId, bool error);
    void listInfo(const QUrlInfo &urlInfo);
    void updateDataTransferProgress(qint64 readBytes, qint64 totalBytes);

private:
    Ui::Publikatu *ui;

    DbManager db;

    int recordId;

    QString recordFileName;
    QString recordFolderPath;
    QString recordErabakiakFileName;
    QString entity_code;
    QString ftp_server;
    QString ftp_port;
    QString ftp_user;
    QString ftp_pass;

    QFtp *ftp;

    QHash<QString, bool> isDirectory; // El resultado de un "ftp.list()" y si es directorio o no.
    QString currentDir; // El nombre del directorio en el que estamos (o queremos estar).
    QStringList files2Upload; // Lista de archivos a subir
    QFile *upFile; // Actual archivo a subir

    void checkDir(QString dirName);
    void uploadFile();
    QString file2Human(QString file);
};

#endif // PUBLIKATU_H
