#include "publikatu.h"
#include "ui_publikatu.h"

Publikatu::Publikatu(int record_id, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Publikatu)
{
    ui->setupUi(this);

    this->recordId = record_id;

    setWindowTitle(tr("Akta publikatu"));

    setFixedSize (400, 330);

    this->ui->progressBar->setMaximum(100);
    this->ui->progressBar->setValue(0);
    this->ui->progressBar->setTextVisible(false);

    QSettings settings("bideoakta", "iametza");

    //this->entity_code = settings.contains("entity_code") ? settings.value("entity_code").toString() : "";
    //2018-06-18: Entitate kodea orain ez da behar. Entitate bakoitzak bere FTP erabiltzailea edukiko du eta
    // bertan edukiko duen "ficheros" karpetan utzi behar dira aktak.
    this->entity_code = "ficheros";
    this->ftp_server = settings.contains("ftp_server") ? settings.value("ftp_server").toString() : "";
    this->ftp_port = settings.contains("ftp_port") ? settings.value("ftp_port").toString() : "";
    this->ftp_user = settings.contains("ftp_user") ? settings.value("ftp_user").toString() : "";
    this->ftp_pass = settings.contains("ftp_pass") ? Funtzioak::decrypt(settings.value("ftp_pass").toString()) : "";

    if (!this->entity_code.isEmpty()){

        if(!this->ftp_server.isEmpty() && !this->ftp_user.isEmpty() && !this->ftp_pass.isEmpty()){
            this->ftp_port = !this->ftp_port.isEmpty() ? this->ftp_port : "21";

            if (db.isOpen()){
                QSqlQuery query;

                query.prepare("SELECT * FROM record WHERE id=:recordId");
                query.bindValue(":recordId", this->recordId);
                query.exec();

                query.first();
                if (query.isValid()){
                    // Recogemos los datos necesarios
                    this->recordFileName = query.value("fileName").toString();
                    this->recordFolderPath = query.value("folderPath").toString();
                    this->recordErabakiakFileName = query.value("erabakiakFile").toString();

                    // Creamos una lista con los ficheros a subir
                    this->files2Upload = QStringList();

                    // audio
                    this->files2Upload.append(this->recordFolderPath + "/" + this->recordFileName + ".mp3");

                    // akta
                    this->files2Upload.append(this->recordFolderPath + "/" + this->recordFileName + ".xml");
                    this->files2Upload.append(this->recordFolderPath + "/" + Funtzioak::getSignedFileName(this->recordId, "akta"));

                    // erabakiak
                    this->files2Upload.append(this->recordErabakiakFileName);
                    this->files2Upload.append(this->recordFolderPath + "/" + Funtzioak::getSignedFileName(this->recordId, "erabakiak"));

                    // fitxategi gehigarriak
                    QStringListIterator filesItr(query.value("files").toString().split("@@_@@"));
                    while (filesItr.hasNext()){
                        this->files2Upload.append(filesItr.next());
                    }

                    // deshabilitamos el botón para cerrar la ventana hasta nuevo aviso
                    this->ui->itxiBotoia->setDisabled(true);

                    // pintamos el primer mensaje en el área de texto
                    this->ui->mezua->setText(tr("Zerbitzarira konektatzen...."));

                    // Empieza la juerga FTP
                    this->ftp = new QFtp(this);

                    connect(this->ftp, SIGNAL(commandFinished(int,bool)), this, SLOT(ftpCommandFinished(int,bool)));
                    connect(this->ftp, SIGNAL(listInfo(QUrlInfo)), this, SLOT(listInfo(QUrlInfo)));
                    connect(this->ftp, SIGNAL(dataTransferProgress(qint64,qint64)), this, SLOT(updateDataTransferProgress(qint64,qint64)));

                    qDebug() << "connect to host" << this->ftp_server << this->ftp_port << this->ftp_user << this->ftp_pass;

                    this->ftp->connectToHost(this->ftp_server, this->ftp_port.toInt());
                }
                else{
                    this->ui->mezua->setText("ERROREA: erregistroa ez da aurkitu.");
                }
            }
            else{
                this->ui->mezua->setText("ERROREA: Datu-basearen konexioa galdu da.");
            }
        }
        else{
            this->ui->mezua->setText(tr("ERROREA: FTP zerbitzaria konfiguratu behar da."));
        }
    }
    else{
        this->ui->mezua->setText(tr("ERROREA: Udalaren kodea ezarri behar da."));
    }
}

Publikatu::~Publikatu()
{
    delete ui;
}

void Publikatu::on_itxiBotoia_clicked()
{
    emit publikatuEnd();

    this->close();
}

void Publikatu::ftpCommandFinished(int, bool error)
{
    qDebug() << "ftp ommand finished" << error;
    if (this->ftp->currentCommand() == QFtp::ConnectToHost){
        if (!error){
            this->ui->mezua->append(tr("Saioa hasten...."));

            this->ftp->login(this->ftp_user, this->ftp_pass);
        }
        else{
            this->ui->mezua->append(tr("ERROREA: Ezin izan da konexioa ezarri."));
        }
    }

    else if (this->ftp->currentCommand() == QFtp::Login){
        if(!error){
            this->ui->mezua->append(tr("Egitura sortzen...."));

            // Udalaren direktorioa existitzen da?
            this->checkDir(this->entity_code);
        }
        else{
            this->ui->mezua->append(tr("ERROREA: Ezin izan da saioa hasi."));
        }
    }

    else if (this->ftp->currentCommand() == QFtp::List){
        if(!error){
            // ¿Qué hacemos?
            if (!this->currentDir.isEmpty()){ // Comprobar si existe un directorio
                QHash<QString, bool>::const_iterator valueIt = this->isDirectory.find(this->currentDir);
                if(valueIt != this->isDirectory.end() && valueIt.value()){
                    this->ftp->cd(this->currentDir);
                }
                else{
                    this->ftp->mkdir(this->currentDir);
                }
            }
        }
        else{
            this->ui->mezua->append(tr("ERROREA: Ezin izan da direktorioaren informazioa jaso."));
        }
    }

    else if (this->ftp->currentCommand() == QFtp::Mkdir){
        if (!error){
            this->ftp->cd(this->currentDir);
        }
        else{
            this->ui->mezua->append(tr("ERROREA: Ezin izan da direktorioa sortu."));
        }
    }

    else if (this->ftp->currentCommand() == QFtp::Cd){
        if (!error){
            if (this->currentDir == this->entity_code){
                // record-aren direktorioa existitzen da?
                this->checkDir(this->recordFileName);
            }
            else if (this->currentDir == this->recordFileName){
                this->ui->mezua->append(tr("Fitxategiak igotzen...."));

                this->uploadFile();
            }
            else{
                this->ui->mezua->append(tr("ERROREA: Direktorio ezezaguna."));

                this->ui->itxiBotoia->setDisabled(false);
            }
        }
        else{
            this->ui->mezua->append(tr("ERROREA: Ezin izan da direktorioa aldatu."));
        }
    }

    else if (this->ftp->currentCommand() == QFtp::Put){
        if (!error){
            this->upFile->close();

            this->ui->mezua->moveCursor(QTextCursor::End);
            this->ui->mezua->insertPlainText(tr(" - igota"));

            // hurrengo fitxategia igo
            this->files2Upload.pop_front();

            this->uploadFile();
        }
        else{
            this->ui->mezua->moveCursor(QTextCursor::End);
            this->ui->mezua->insertPlainText(tr(" - ez da igo"));

            this->ui->mezua->append(tr("ERROREA: Ezin izan da fitxategia igo."));
        }
    }

    if (error){
        this->ui->itxiBotoia->setDisabled(false);
    }
}

void Publikatu::listInfo(const QUrlInfo &urlInfo)
{
    this->isDirectory[urlInfo.name()] = urlInfo.isDir();
}

void Publikatu::checkDir(QString dirName)
{
    this->isDirectory.clear();

    this->currentDir = dirName;

    this->ftp->list();
}

void Publikatu::uploadFile()
{
    QFileInfo txekFile;

    if (this->files2Upload.count() > 0){
        txekFile = QFileInfo(this->files2Upload.first());
        if (txekFile.exists() && txekFile.isFile()){
            this->upFile = new QFile(this->files2Upload.first());
            if(this->upFile->open(QIODevice::ReadOnly)){
                this->ui->mezua->append(tr("Fitxategia: ") + this->file2Human(txekFile.fileName()));

                this->ftp->put(this->upFile, txekFile.fileName());
            }
            else{
                this->ui->mezua->append(tr("ERROREA: Ezin izan da fitxategia irakurri."));

                this->ui->itxiBotoia->setDisabled(false);
            }
        }
        else{
            this->files2Upload.pop_front();

            this->uploadFile();
        }
    }
    else{
        this->ui->mezua->append(tr("Eginda!"));

        // Creamos un fichero "oculto" para saber que se ha publicado
        // Así es más fácil poder volver a publicar (solo habría que borrarlo)
        QFile file(this->recordFolderPath + "/.publikatuta");
        file.open(QIODevice::WriteOnly);
        file.close();

        this->ftp->close();

        this->ui->itxiBotoia->setDisabled(false);
    }
}

void Publikatu::updateDataTransferProgress(qint64 readBytes, qint64 totalBytes)
{
    this->ui->progressBar->setValue(int((readBytes * 100) / totalBytes));
}

QString Publikatu::file2Human(QString file)
{
    if (file.compare(this->recordFileName + ".mp3") == 0){
        return tr("audioa");
    }
    else if (file.compare(this->recordFileName + ".xml") == 0){
        return tr("akta");
    }
    else if (file.compare(Funtzioak::getSignedFileName(this->recordId, "akta")) == 0){
        return tr("aktaren sinadura");
    }
    else if (this->recordErabakiakFileName.endsWith(file)){ // recordErabakiakFileName path osoa duelako
        return tr("erabakien dokumentua");
    }
    else if (file.compare(Funtzioak::getSignedFileName(this->recordId, "erabakiak")) == 0){
        return tr("erabakien sinadura");
    }
    else{
        return file;
    }
}
