#include "nabigatzailea.h"

Nabigatzailea::Nabigatzailea(QString url, QWidget *parent) : QWidget(parent)
{
    this->m_checkUrl = "";

    /// Create the UI
    QHBoxLayout *appLayout = new QHBoxLayout;
    appLayout->setSpacing(0);
    appLayout->setContentsMargins(0,0,0,0);

    QWebEngineProfile *profile = QWebEngineProfile::defaultProfile();

    CustomUrlSchemeHandler *handler = new CustomUrlSchemeHandler(this);
    profile->removeAllUrlSchemeHandlers();
    profile->installUrlSchemeHandler("idazki", handler);
    profile->installUrlSchemeHandler("idazkidelegado", handler);

    m_view = new QWebEngineView(this);

    //qDebug() << profile->httpUserAgent();
    //qDebug() << "Url" << url;

    QWebEnginePage * page = new QWebEnginePage(profile, m_view);
    page->setUrl(QUrl(url));

    m_view->setPage(page);

    appLayout->addWidget(m_view);

    this->setLayout(appLayout);
    this->setWindowTitle("giltz@");

    connect(m_view, SIGNAL(urlChanged(QUrl)), this, SLOT(on_urlChanged(QUrl)));
}

Nabigatzailea::~Nabigatzailea()
{
    emit nabigatzaileaItxi();
}

void Nabigatzailea::setCheckUrl(QString url)
{
    this->m_checkUrl = url;
}

void Nabigatzailea::on_urlChanged(QUrl url)
{
    if (this->m_checkUrl.compare("") != 0 && this->m_checkUrl.compare(url.url()) == 0){
        this->close();
    }
}
