#ifndef MEDIAAPP_H
#define MEDIAAPP_H

#include <QTimer>
#include <QWidget>
#include <QtSql>
#include <QTreeView>
#include <QStyle>
#include <QHBoxLayout>
#include "item.h"
#include "atendee.h"
#include "log.h"
#include <QLineEdit>
#include <QTime>
#include <QMediaPlayer>
#include <QMessageBox>
#include <QHeaderView>
#include <QTableView>
#include <QIcon>
#include "interventionmodel.h"
#include "editinterventiondialog.h"
#include "editnotedialog.h"
#include "steps.h"
#include "dbmanager.h"

class Player;
class QBoxLayout;
class QLabel;
class QSlider;
class QToolButton;
class QTimer;

class timeEdit: public QLineEdit
{
    Q_OBJECT
protected:
    void focusInEvent(QFocusEvent* e);

signals:
    void lock();
    void unlock();

};

class MediaApp : public QWidget
{
    Q_OBJECT
public:
    MediaApp(int record_id, QWidget *parent = 0);
    ~MediaApp();

    //void openFile(const QString & fileName);

private Q_SLOTS:

    void onStateChanged(QMediaPlayer::State state);
    void onPositionChanged(qint64 position);
    void onInterventionTreeDoubleClicked(QModelIndex index);
    void onNotesZerrendaDoubleClicked(QModelIndex index);

    void setPosition(int position);

    void checkItemAtendee();
    void checkItemAtendeeList();
    void checkButtons();
    void restartChecking();
    void lock();
    void unlock();
    void editInitTime();
    void editEndTime();
    bool editTime(QString editName,int initEnd);
    void writeCompleteLog();


    void onEditInterventionDialogAccepted();
    void onEditInterventionDialogDeleteClicked();
    void onNewInterventionClicked(bool);
    void onNewInterventionDialogAccepted();
    void onSaveButtonClicked();
    void onSaveAndSignButtonClicked();
    void onEditInterventionClicked(bool);
    void onDeleteInterventionClicked(bool);

    void onNewNoteClicked(bool);
    void onNewNoteDialogAccepted();
    void onEditNoteClicked(bool);
    void onEditNoteDialogAccepted();
    void onEditNoteDialogDeleteClicked();
    void onDeleteNoteClicked(bool);
protected:
    //void mouseMoveEvent(QMouseEvent *event);

private:
    QToolButton *initButton(QStyle::StandardPixmap icon, const QString & tip,
                            QObject *dstobj, const char *slot_method, QLayout *layout);
    void createUI(QBoxLayout *appLayout);

    QString m_baseDir;
    QToolButton *m_openButton;
    QToolButton *m_fullScreenButton;
    QToolButton *m_playButton;
    QToolButton *m_pauseButton;
    QToolButton *m_stopButton;
    QToolButton *m_editItemButton;
    QToolButton *m_newItemButton;
    QToolButton *m_deleteItemButton;
    QToolButton *m_editInterventionButton;
    QToolButton *m_newInterventionButton;
    QToolButton *m_deleteInterventionButton;
    QToolButton *m_editNoteButton;
    QToolButton *m_newNoteButton;
    QToolButton *m_deleteNoteButton;
    QSlider *m_positionSlider;
    QSlider *m_volumeSlider;
    QLabel *m_positionLabel;
    QLabel *m_volumeLabel;
    QLabel *m_itemsLabel;
    QLabel *m_atendeesLabel;
    QLabel *m_notesLabel;
    QTimer m_fullScreenTimer;
    QList<Item> itemList;
    QList<Atendee> atendeeList;
    QList<Item> extendedItemList;
    QList<Atendee> extendedAtendeeList;
    QHBoxLayout *itemsLayout;
    QHBoxLayout *atendeesLayout;
    QString sessionName;
    QString sessionType;
    QString dateTime;
    QString shortDescription;
    QString folderPath;
    bool locked;
    QString fileName;
    bool audioVideo;
    int recordId;
    QLabel *m_izfeLogoLabel;

    InterventionModel *m_interventionModel;
    QTreeView *m_interventionTree;
    QSortFilterProxyModel *m_proxyModel;
    QModelIndex m_modifyingIndex;

    InterventionModel *m_itemInterventionModel;
    QTreeView *m_itemInterventionTree;
    QSortFilterProxyModel *m_itemProxyModel;
    QModelIndex m_itemModifyingIndex;

    QSqlRelationalTableModel *m_notesModel;
    QTableView *m_notesZerrenda;

    QMediaPlayer *m_player;

    DbManager db;

    QPoint erdianKokatu(int zabalera, int altuera);

    void openEditDialog(QString dialogType);
    bool editTimes(QString type, QString id, QString name, qint64 newStartTime, qint64 newEndTime);
    bool newTimes(QString type, QString id, QString name, qint64 newStartTime, qint64 newEndTime);
    void writeCompleteLogFromTree();
    void oharra(QString mezua);
    void oharrakGorde();
    void showError(const QSqlError &err);

signals:
    void signFormSetCentralWidget(int record_id);
};

#endif
