#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QMenuBar>
#include <QtSql>
#include <QtWidgets>
#include <QDesktopWidget>
#include <QSettings>
#include <QCloseEvent>

class QAction;
class QActionGroup;
class QLabel;
class QMenu;
class QMenuBar;

#include "configurator.h"
#include "recorder.h"
#include "editatendee.h"
#include "edittheme.h"
#include "editsessiontype.h"
#include "editrol.h"
#include "settingsaudio.h"
#include "settingsvideo.h"
#include "foldersettings.h"
#include "login.h"
#include "firstscreen.h"
#include "selectrecord.h"
#include "mediaapp.h"
#include "signform.h"
#include "dbmanager.h"


class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();

    void closeEvent(QCloseEvent *event);
protected:
    // this event is called, when a new translator is loaded or the system language is changed
    void changeEvent(QEvent*);

private:
    Login *login;
    FirstScreen *firstScreen;
    Configurator *configurator;
    Recorder *recorderWidget;
    MediaApp *mediaAppWidget;
    SignForm *signFormWidget;

    QSettings setttings;

    DbManager db;

    void createActions();
    void createMenus();
    void createLanguageMenu();

    void loadLanguage(const QString& language);
    void switchTranslator(QTranslator& translator, const QString& filename);

    void editatuAtendee();
    void editatuTheme();
    void editatuSessionType();
    void editatuRol();
    void irekiConfigurator();
    void aukeratuRecord();

    void ezarpenakAudio();
    void ezarpenakVideo();
    void ezarpenakFolder();

    QPoint erdianKokatu (int zabalera, int altuera);

    QMenu *fileMenu;
    QMenu *editMenu;
    QMenu *languageMenu;
    QMenu *settingsMenu;
     
    QAction *newAct;
    QAction *openAct;
    QAction *exitAct;
    
    QAction *atendeeAct;
    QAction *themeAct;
    //QAction *sessionTypeAct;
    QAction *rolAct;

    QAction *audioAct;
    QAction *videoAct;
    QAction *folderAct;

    settingsAudio *settingsAudioWidget;
    settingsVideo *settingsVideoWidget;
    selectRecord *selectRecordWidget;

    QLabel *infoLabel;

    QTranslator translator;
    QTranslator qtBaseTranslator;
    QString currentLanguage;
    QString languagePath;

public slots:
    void onLoginZuzena(QString languageCode);
    void onNewRecording();

private slots:
    void on_firstScreenSetCentralWidget();
    void on_configuratorSetCentralWidget(int record_id);
    void on_recorderSetCentralWidget(int record_id);
    void on_mediaAppSetCentralWidget(int record_id);
    void on_signFormSetCentralWidget(int record_id);

    void onOpenRecording();

    void on_sessionTypeKargatu();
protected slots:
    // this slot is called by the language menu actions
    void slotLanguageChanged(QAction* action);

};



#endif // MAINWINDOW_H
