#include "mainwindow.h"

MainWindow::MainWindow() : login(new Login)
{

    /*QWidget *widget = configurator;
    setCentralWidget(widget);*/
    setCentralWidget(login);

    connect( login, SIGNAL(loginZuzena(QString)), this, SLOT(onLoginZuzena(QString)) );

    /*QWidget *topFiller = new QWidget;
    topFiller->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    QWidget *bottomFiller = new QWidget;
    bottomFiller->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    QVBoxLayout *layout = new QVBoxLayout;
    layout->setMargin(5);
    layout->addWidget(topFiller);
    layout->addWidget(bottomFiller);
    widget->setLayout(layout);*/



    /*this->setStyleSheet(QLatin1String("QLabel{}"
                                      "QLineEdit{}"
                                      "QListWidget::item{}"));
                                      //"QPushButton{font: 12pt;}"));*/

    setWindowTitle(tr("Akta gardena"));
    setMinimumSize(610, 565);
    /*setMaximumSize(610, 566);*/
    //setFixedSize(610, 565);

    // 2019-06-10 ez da behar (fijoak direlako orain) eta gainera datu base konexioa irekitzen du, puntu hontan komeni ez zaiguna.
    //configurator = new Configurator(); //para que no se mate "on_sessionTypeKargatu" si todavía no se ha abierto ningún Configurator
}

void MainWindow::createActions()
{

    newAct = new QAction(tr("&New"), this);
    newAct->setShortcut(tr("Ctrl+N"));
    newAct->setStatusTip(tr("New recording"));
    connect(newAct, &QAction::triggered, this, &MainWindow::irekiConfigurator);

    openAct = new QAction(tr("&Ireki"), this);
    openAct->setShortcut(tr("Ctrl+O"));
    openAct->setStatusTip(tr("Open record"));
    connect(openAct, &QAction::triggered, this, &MainWindow::aukeratuRecord);

    exitAct = new QAction(tr("E&xit"), this);
    exitAct->setShortcuts(QKeySequence::Quit);
    exitAct->setStatusTip(tr("Exit the application"));
    connect(exitAct, &QAction::triggered, this, &QWidget::close);


    atendeeAct = new QAction(tr("&Atendee"), this);
    atendeeAct->setShortcut(tr("Ctrl+A"));
    atendeeAct->setStatusTip(tr("Atendees settings"));
    connect(atendeeAct, &QAction::triggered, this, &MainWindow::editatuAtendee);

    themeAct = new QAction(tr("&Theme"), this);
    themeAct->setShortcut(tr("Ctrl+T"));
    themeAct->setStatusTip(tr("Themes settings"));
    connect(themeAct, &QAction::triggered, this, &MainWindow::editatuTheme);

    /*sessionTypeAct = new QAction(tr("&Session type"), this);
    sessionTypeAct->setShortcut(tr("Ctrl+S"));
    sessionTypeAct->setStatusTip(tr("Session types"));
    connect(sessionTypeAct, &QAction::triggered, this, &MainWindow::editatuSessionType);*/

    rolAct = new QAction(tr("&Rol"), this);
    rolAct->setShortcut(tr("Ctrl+R"));
    rolAct->setStatusTip(tr("Roles"));
    connect(rolAct, &QAction::triggered, this, &MainWindow::editatuRol);

    audioAct = new QAction(tr("Audio"), this);
    audioAct->setShortcut(tr("Ctrl+U"));
    audioAct->setStatusTip(tr("Audio settings"));
    connect(audioAct, &QAction::triggered, this, &MainWindow::ezarpenakAudio);

    /*folderAct = new QAction(tr("Folders"), this);
    folderAct->setStatusTip(tr("Folder settings"));
    connect(folderAct, &QAction::triggered, this, &MainWindow::ezarpenakFolder);*/


    settingsAudioWidget = new settingsAudio();
    //settingsAudioWidget->setAttribute(Qt::WA_DeleteOnClose);
    settingsAudioWidget->setWindowModality(Qt::ApplicationModal);

    settingsVideoWidget = new settingsVideo();
    settingsVideoWidget->setWindowModality(Qt::ApplicationModal);

/*
    videoAct = new QAction(tr("Bideo"), this);
    videoAct->setShortcut(tr("Ctrl+B"));
    videoAct->setStatusTip(tr("Bideo ezarpenak"));
    connect(videoAct, &QAction::triggered, this, &MainWindow::ezarpenakVideo);

    settingsVideoWidget = new settingsVideo();
    //settingsVideoWidget->setAttribute(Qt::WA_DeleteOnClose);
    settingsVideoWidget->setWindowModality(Qt::ApplicationModal);
*/
}

void MainWindow::createMenus()
{
    fileMenu = menuBar()->addMenu(tr("&File"));
    fileMenu->addAction(newAct);
    fileMenu->addAction(openAct);
    fileMenu->addAction(exitAct);
    ///fileMenu->setEnabled(false);

    editMenu = menuBar()->addMenu(tr("&Edit"));
    editMenu->addAction(atendeeAct);
    editMenu->addAction(themeAct);
    //editMenu->addAction(sessionTypeAct);
    ///editMenu->addAction(rolAct);
    ///editMenu->setEnabled(false);

    settingsMenu = menuBar()->addMenu(tr("E&zarpenak"));
    settingsMenu->addAction(audioAct);
    /// settingsMenu->actions().at(1)->setVisible(false);
    /// settingsMenu->addAction(folderAct);
    /// settingsMenu->addAction(videoAct);
    /// settingsMenu->setEnabled(false);
   
  
//    languageMenu = menuBar()->addMenu(tr("&Language"));
//    languageMenu->setEnabled(false);
//    createLanguageMenu();
}

void MainWindow::createLanguageMenu(void)
{
    QSettings settings("bideoakta", "iametza");
    settings.setValue("defaultLanguage", "eu" );

    QActionGroup* langGroup = new QActionGroup(languageMenu);
    langGroup->setExclusive(true);

    connect(langGroup, SIGNAL (triggered(QAction *)), this, SLOT (slotLanguageChanged(QAction *)));
    QStringList hizkuntzak;
    hizkuntzak.append("Euskara");
    hizkuntzak.append("Gaztelania");
    QStringList hizkuntzaKodeak;
    hizkuntzaKodeak.append("eu");
    hizkuntzaKodeak.append("es");

    // languages direktoriotik hartu fitxategiak
    languagePath.append(":/languages");
    QDir dir(languagePath);
    QStringList fileNames = dir.entryList(QStringList("bideoakta_*.qm"));
    // qdebug() << dir.path();

    for(int i=0; i < fileNames.size(); i++) {
        QString locale;
        locale = fileNames[i];
        locale.truncate(locale.lastIndexOf('.')); // "bideoakta_eu"
        locale.remove(0, locale.indexOf('_') + 1); // "eu"


        int hizkuntzaIndex = hizkuntzaKodeak.indexOf(locale);
        // gehitu menuan
        QString hizkuntza = hizkuntzak[hizkuntzaIndex];
        QByteArray ba = hizkuntza.toLocal8Bit();
        const char *c_str2 = ba.data();
        QAction *hizkuntzaAction = new QAction(tr(c_str2), this);
        hizkuntzaAction->setCheckable(true);
        hizkuntzaAction->setData(locale);
        languageMenu->addAction(hizkuntzaAction);
        langGroup->addAction(hizkuntzaAction);

        QString currentLanguage = QLocale().name().remove( QRegularExpression("_\\w+") );
        if(currentLanguage == locale){
            hizkuntzaAction->setChecked(true);
            hizkuntzaAction->setDisabled(true);
        }
    }

}

void MainWindow::slotLanguageChanged(QAction* action)
{
 if(0 != action) {
    // load the language dependant on the action content
    loadLanguage(action->data().toString());
 }
}

void MainWindow::loadLanguage(const QString &language)
{

    QString currentLanguage = QLocale().name().remove( QRegularExpression("_\\w+") );
    if(currentLanguage != language) {
      QLocale locale = QLocale(language);
      QLocale::setDefault(locale); /// hurrengoan hau kargatzeko

      qApp->removeTranslator(&translator);
      if (translator.load(QLocale(), QLatin1String("bideoakta"), QLatin1String("_"), QLatin1String(":/languages"))){
          qApp->installTranslator(&translator);
      }

      if (qtBaseTranslator.load(QLocale(), QLatin1String("qtbase"), QLatin1String("_"), QLatin1String(":/languages"))){
          //qDebug() << "qtBaseTranslator: " << qtBaseTranslator.objectName();
          qApp->installTranslator(&qtBaseTranslator);
      }


     }

}


void MainWindow::editatuAtendee(){
    editAtendee *editAtendeeWidget = new editAtendee();
    editAtendeeWidget->setAttribute(Qt::WA_DeleteOnClose);
    editAtendeeWidget->setWindowModality(Qt::ApplicationModal);

    // Centramos la ventana
    editAtendeeWidget->move(erdianKokatu(editAtendeeWidget->width(), editAtendeeWidget->height()));

    // Mostramos la ventana
    editAtendeeWidget->show();
}

void MainWindow::editatuTheme(){
    editTheme *editThemeWidget = new editTheme();
    editThemeWidget->setAttribute(Qt::WA_DeleteOnClose);
    editThemeWidget->setWindowModality(Qt::ApplicationModal);

    // Centramos la ventana
    editThemeWidget->move(erdianKokatu(editThemeWidget->width(), editThemeWidget->height()));

    // Mostramos la ventana
    editThemeWidget->show();
}

void MainWindow::editatuSessionType(){
    editSessionType *editSessionTypeWidget = new editSessionType();
    editSessionTypeWidget->setAttribute(Qt::WA_DeleteOnClose);
    editSessionTypeWidget->setWindowModality(Qt::ApplicationModal);

    // Centramos la ventana
    editSessionTypeWidget->move(erdianKokatu(editSessionTypeWidget->width(), editSessionTypeWidget->height()));

    // Mostramos la ventana
    editSessionTypeWidget->show();

    connect(editSessionTypeWidget, SIGNAL(sessionTypeKargatu()), this, SLOT(on_sessionTypeKargatu()));
}

void MainWindow::editatuRol(){
    editRol *editRolWidget = new editRol();
    editRolWidget->setAttribute(Qt::WA_DeleteOnClose);
    editRolWidget->setWindowModality(Qt::ApplicationModal);

    // Centramos la ventana
    editRolWidget->move(erdianKokatu(editRolWidget->width(), editRolWidget->height()));

    // Mostramos la ventana
    editRolWidget->show();
}

void MainWindow::ezarpenakAudio(){
    if (settingsAudioWidget->isVisible()){
        settingsAudioWidget->activateWindow();
        settingsAudioWidget->raise();
    }
    else{
        // Centramos la ventana
        settingsAudioWidget->move(erdianKokatu(settingsAudioWidget->width(), settingsAudioWidget->height()));

        // Mostramos la ventana
        settingsAudioWidget->show();
    }
}

void MainWindow::ezarpenakVideo()
{
    /*
    if (settingsVideoWidget->isVisible()){
        settingsVideoWidget->activateWindow();
        settingsVideoWidget->raise();
    }
    else{
        // Centramos la ventana
        settingsVideoWidget->move(erdianKokatu(settingsVideoWidget->width(), settingsVideoWidget->height()));

        // Mostramos la ventana
        settingsVideoWidget->show();
    }*/
}

void MainWindow::ezarpenakFolder(){
    /*FolderSettings *folderSettingsWidget = new FolderSettings();
    folderSettingsWidget->setAttribute(Qt::WA_DeleteOnClose);
    folderSettingsWidget->setWindowModality(Qt::ApplicationModal);

    // Centramos la ventana
    folderSettingsWidget->move(erdianKokatu(folderSettingsWidget->width(), folderSettingsWidget->height()));

    // Mostramos la ventana
    folderSettingsWidget->show();*/
}

void MainWindow::irekiConfigurator()
{
    configurator = new Configurator();
    setCentralWidget(configurator);

    connect(configurator, SIGNAL(recorderSetCentralWidget(int)), this, SLOT(on_recorderSetCentralWidget(int)));
}

void MainWindow::aukeratuRecord()
{
    selectRecordWidget = new selectRecord();
    setCentralWidget(selectRecordWidget);

    connect(selectRecordWidget, SIGNAL(mediaAppSetCentralWidget(int)), this, SLOT(on_mediaAppSetCentralWidget(int)));
    connect(selectRecordWidget, SIGNAL(configuratorSetCentralWidget(int)), this, SLOT(on_configuratorSetCentralWidget(int)));
    connect(selectRecordWidget, SIGNAL(signFormSetCentralWidget(int)), this, SLOT(on_signFormSetCentralWidget(int)));
}

QPoint MainWindow::erdianKokatu (int zabalera, int altuera)
{
    QPoint puntu;

    /* Pantailaren erdian kokatzeko
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    puntu.setX((screenGeometry.width() - zabalera) / 2);
    puntu.setY((screenGeometry.height() - altuera) / 2);*/

    /* Aplikazioaren erdian kokatzeko */
    puntu.setX(this->pos().x() + ((this->width() - zabalera) / 2));
    puntu.setY(this->pos().y() + ((this->height() - altuera) / 2));

    return (puntu);
}

void MainWindow::onLoginZuzena(QString languageCode)
{
    this->loadLanguage(languageCode);

    // Comprobar que la base de datos tiene todas las tablas y campos necesarios
    if (this->db.open()){
        this->db.checkDatabase();
    }

    createActions();

    statusBar()->showMessage(Funtzioak::loadPublishConf());

    createMenus();

    setMinimumSize(610, 565);
    setMaximumSize(QWIDGETSIZE_MAX, QWIDGETSIZE_MAX);

    this->on_firstScreenSetCentralWidget();
}

void MainWindow::onNewRecording()
{
    irekiConfigurator();
}

void MainWindow::on_firstScreenSetCentralWidget()
{
    firstScreen = new FirstScreen();
    setCentralWidget(firstScreen);

    connect( firstScreen, SIGNAL(newRecording()), this, SLOT(onNewRecording()) );
    connect( firstScreen, SIGNAL(openRecording()), this, SLOT(onOpenRecording()) );
}

void MainWindow::onOpenRecording()
{
    aukeratuRecord();
}

void MainWindow::changeEvent(QEvent* event)
{
 if(0 != event) {
  switch(event->type()) {
   // this event is send if a translator is loaded
   case QEvent::LanguageChange:
    ///
    break;

   // this event is send, if the system, language changes
   case QEvent::LocaleChange:
   {
    QString locale = QLocale::system().name();
    locale.truncate(locale.lastIndexOf('_'));
    loadLanguage(locale);
   }
   break;
  }
 }
 QMainWindow::changeEvent(event);
}

void MainWindow::on_configuratorSetCentralWidget(int record_id)
{
    configurator = new Configurator();
    setCentralWidget(configurator);

    configurator->datuakKargatu(record_id);

    connect(configurator, SIGNAL(recorderSetCentralWidget(int)), this, SLOT(on_recorderSetCentralWidget(int)));
}

void MainWindow::on_recorderSetCentralWidget(int record_id)
{
    recorderWidget = new Recorder(record_id);
    setCentralWidget(recorderWidget);

    connect(recorderWidget, SIGNAL(mediaAppSetCentralWidget(int)), this, SLOT(on_mediaAppSetCentralWidget(int)));
}

void MainWindow::on_mediaAppSetCentralWidget(int record_id)
{
    mediaAppWidget = new MediaApp(record_id);
    setCentralWidget(mediaAppWidget);

    connect(mediaAppWidget, SIGNAL(signFormSetCentralWidget(int)), this, SLOT(on_signFormSetCentralWidget(int)));
}

void MainWindow::on_signFormSetCentralWidget(int record_id)
{
    signFormWidget = new SignForm(record_id);
    setCentralWidget(signFormWidget);

    connect(signFormWidget, SIGNAL(firstScreenSetCentralWidget()), this, SLOT(on_firstScreenSetCentralWidget()));
}

void MainWindow::closeEvent (QCloseEvent *event)
{
    int ret = QMessageBox::question( this, "Akta gardena",
                                     tr("Are you sure?"),
                                     QMessageBox::Ok | QMessageBox::Cancel,
                                     QMessageBox::Cancel);
    if (ret == QMessageBox::Ok){
        if (this->db.isOpen()){
            this->db.closeConnection();
        }

        event->accept();
    } else {
        event->ignore();
    }
}

void MainWindow::on_sessionTypeKargatu()
{
    if (configurator->isVisible()){
        configurator->sessionTypeReload();
    }
}
