/**
* @author     iametza interaktiboa
* @date       July 6, 2017
* @version    1.1.0
*/

// #include "configurator.h"
#include <QApplication>
#include <QDebug>
#include <QDesktopWidget>
#include <QTranslator>
#include <QSettings>
#include <QWebEngineUrlScheme>
#include <QWebEngineProfile>
#include <QWebEngineSettings>

#include "mainwindow.h"

#ifdef _WIN32
//#pragma comment(linker, "/SUBSYSTEM:console")
#pragma comment(linker,"/ENTRY:mainCRTStartup")
#endif

void setDataFolder()
{
    QSettings settings("bideoakta", "iametza");
    QString path = QDir::homePath() + "/akta-gardena";

    if (QDir(path).exists()){
        QFileInfo my_dir(path);

        if(my_dir.isWritable())
            settings.setValue("data_folder", path);
        else
            settings.setValue("data_folder", QDir::homePath());
    }
    else{
        if (QDir().mkdir (path))
            settings.setValue("data_folder", path);
        else
            settings.setValue("data_folder", QDir::homePath());
    }
}

int main(int argc, char *argv[])
{
    QWebEngineUrlScheme scheme("idazki");
    scheme.setSyntax(QWebEngineUrlScheme::Syntax::HostAndPort);
    scheme.setDefaultPort(8082);
    scheme.setFlags(QWebEngineUrlScheme::LocalAccessAllowed);
    QWebEngineUrlScheme::registerScheme(scheme);

    QWebEngineUrlScheme scheme2("idazkidelegado");
    scheme2.setSyntax(QWebEngineUrlScheme::Syntax::HostAndPort);
    scheme2.setDefaultPort(8082);
    scheme2.setFlags(QWebEngineUrlScheme::LocalAccessAllowed);
    QWebEngineUrlScheme::registerScheme(scheme2);

    QApplication a(argc, argv);
    QCoreApplication::setOrganizationName("iametza");
    QCoreApplication::setOrganizationDomain("iametza.eus");
    QCoreApplication::setApplicationName("Akta gardena");

    QWebEngineSettings::defaultSettings()->setAttribute(QWebEngineSettings::PluginsEnabled, true);
#if QT_VERSION >= QT_VERSION_CHECK(5, 13, 0)
    QWebEngineSettings::defaultSettings()->setAttribute(QWebEngineSettings::DnsPrefetchEnabled, true);
    QWebEngineProfile::defaultProfile()->setUseForGlobalCertificateVerification();
#endif

    // Establecer el directorio donde guardar los datos de las grabaciones
    setDataFolder();

    // Hizkuntzak kudeatu
    QTranslator translator, qtBaseTranslator;
    QLocale locale = QLocale("eu");
    QLocale::setDefault(locale);

    // TODO: begiratu settingsen zein den hizkuntza
    if (translator.load(QLocale(), QLatin1String("bideoakta"), QLatin1String("_"), QLatin1String(":/languages"))){
        //qDebug() << "translator: " << translator.objectName();
        qApp->installTranslator(&translator);
    }

    if (qtBaseTranslator.load(QLocale(), QLatin1String("qtbase"), QLatin1String("_"), QLatin1String(":/languages"))){
        //qDebug() << "qtBaseTranslator: " << qtBaseTranslator.objectName();
        qApp->installTranslator(&qtBaseTranslator);
    }

    MainWindow w;

    // Centramos la ventana en la pantalla
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    int x = (screenGeometry.width() - w.width()) / 2;
    int y = (screenGeometry.height() - w.height()) / 2;

    w.move(x, y);

    // Mostramos la ventana
    w.show();

    return a.exec();
}


