#include "log.h"
#include "item.h"
#include "atendee.h"

#define logfilename "/tmp/log.xml"


Log::Log()
{

}
/**
 * @brief Log::InitLog This is the Log constructor, it will initializate Xmlwriter
 * @param record_id integer containing the ID of the record
 */
void Log::InitLog(int record_id)
{
    if (db.isOpen()){
        QSqlQuery query;

        query.prepare("SELECT r.data, r.izena, r.izena_es, r.deskribapena, r.folderPath, r.fileName, CASE WHEN st.izena IS NOT NULL THEN st.izena ELSE r.mota END AS mota_eu, CASE WHEN st.izena_es IS NOT NULL THEN st.izena_es ELSE r.mota END AS mota_es FROM record r LEFT JOIN session_type st ON st.id=r.session_type_id WHERE r.id=:recordId");
        query.bindValue(":recordId", record_id);
        query.exec();

        query.first();
        if (query.isValid()){
            QString filename = query.value("folderPath").toString() + "/" + query.value("fileName").toString() + ".xml";

            file.setFileName(filename);
            file.open(QIODevice::WriteOnly);

            xmlWriter.setDevice(&file);
            xmlWriter.setAutoFormatting(true);
            xmlWriter.writeStartDocument();

            xmlWriter.writeStartElement("LOG");
            xmlWriter.writeStartElement("SessionDescription");

            xmlWriter.writeStartElement("SessionName");
            xmlWriter.writeAttribute("language", "eu");
            xmlWriter.writeCDATA(query.value("izena").toString());
            xmlWriter.writeEndElement();

            xmlWriter.writeStartElement("SessionName");
            xmlWriter.writeAttribute("language", "es");
            xmlWriter.writeCDATA(query.value("izena_es").toString());
            xmlWriter.writeEndElement();

            xmlWriter.writeStartElement("Description");
            xmlWriter.writeCDATA(query.value("deskribapena").toString());
            xmlWriter.writeEndElement();

            xmlWriter.writeStartElement("SessionType");
            xmlWriter.writeAttribute("language", "eu");
            xmlWriter.writeCDATA(query.value("mota_eu").toString());
            xmlWriter.writeEndElement();

            xmlWriter.writeStartElement("SessionType");
            xmlWriter.writeAttribute("language", "es");
            xmlWriter.writeCDATA(query.value("mota_es").toString());
            xmlWriter.writeEndElement();

            xmlWriter.writeTextElement("DateTime", query.value("data").toString());
            xmlWriter.writeEndElement();
            xmlWriter.writeStartElement("Data");
        }
    }
}

/**
 * @brief Log::SaveLogMessage This method will save a message to a file
 * @param type int 0 = speaker/Atendee, 1 = Item
 * @param element the name of the Atendee / Item
 * @param initTime QString in hh:mm:ss format
 * @param endTime QString in hh:mm:ss format
 */
void Log::SaveLogMessage(int type,QString element,QString initTime,QString endTime,QString id)
{
    //// qdebug()<<"SaveLogMessage";
    if(type==0)
    {
        xmlWriter.writeStartElement("speaker");
        xmlWriter.writeStartElement("speakerName");
        xmlWriter.writeCDATA(element);
        xmlWriter.writeEndElement();
    }
    else if (type==1)
    {
        xmlWriter.writeStartElement("item");
        xmlWriter.writeAttribute("id", id);

        QString izena = element;
        QString izena_es = element;
        if (db.isOpen()){
            QSqlQuery query;

            query.prepare("SELECT * FROM theme WHERE id=:id");
            query.bindValue(":id", id);
            query.exec();

            query.first();
            if (query.isValid()){
                izena = query.value("izena").toString();
                izena_es = query.value("izena_es").toString();
            }
        }

        xmlWriter.writeStartElement("itemName");
        xmlWriter.writeAttribute("language", "eu");
        xmlWriter.writeCDATA(izena);
        xmlWriter.writeEndElement();

        xmlWriter.writeStartElement("itemName");
        xmlWriter.writeAttribute("language", "es");
        xmlWriter.writeCDATA(izena_es);
        xmlWriter.writeEndElement();
    }

    xmlWriter.writeTextElement("initTime", initTime);
    xmlWriter.writeTextElement("endTime", endTime);
    xmlWriter.writeEndElement();
}

/**
 * @brief Log::CloseLog This method will close log file
 */
void Log::CloseLog(int record_id, bool sinatzeko)
{
    xmlWriter.writeEndElement(); // Data

    // Oharrak eta audioaren hash-a gorde
    if (sinatzeko && db.isOpen()){
        QSqlQuery query;

        // Oharrak
        query.prepare("SELECT noiz, testua FROM record_notes WHERE record_id=:recordId ORDER BY noiz ASC");
        query.bindValue(":recordId", record_id);
        query.exec();

        query.first(); // bestela isValid false ematen du naiz eta erregistroak egon
        if (query.isValid()){ //SQLite-n QSqlQuery::size funtzioa -1 bueltatzen du beti, ezin da erabili erregistroak dauden edo ez jakiteko
            xmlWriter.writeStartElement("Notes");

            do{
                xmlWriter.writeStartElement("note");
                xmlWriter.writeAttribute("time", query.value("noiz").toString());
                xmlWriter.writeCDATA(query.value("testua").toString());
                xmlWriter.writeEndElement();
            }while(query.next());

            xmlWriter.writeEndElement(); // Notes
        }

        // Audioa, erabakien dokumentua eta fitxategi gehigarrien hash-ak
        query.prepare("SELECT folderPath, fileName, erabakiakFile, files FROM record WHERE id=:recordId");
        query.bindValue(":recordId", record_id);
        query.exec();

        query.first();
        if (query.isValid()){
            QFileInfo txekFile;
            QString fitxategia;

            // Audioa
            fitxategia = query.value("folderPath").toString() + "/" + query.value("fileName").toString() + ".mp3";

            txekFile = QFileInfo(fitxategia);
            if (txekFile.exists() && txekFile.isFile()){
                QFile f(fitxategia);

                if (f.open(QFile::ReadOnly)){
                    QCryptographicHash hash (QCryptographicHash::Sha512);

                    if (hash.addData(&f)){
                        xmlWriter.writeStartElement("audio");
                        xmlWriter.writeAttribute("name", txekFile.fileName());
                        xmlWriter.writeAttribute("algorithm", "SHA-512");
                        xmlWriter.writeAttribute("hash", hash.result().toHex());
                        xmlWriter.writeEndElement();
                    }
                }
            }

            // Erabakien dokumentua
            fitxategia = query.value("erabakiakFile").toString();

            txekFile = QFileInfo(fitxategia);
            if (txekFile.exists() && txekFile.isFile()){
                QFile f(fitxategia);

                if (f.open(QFile::ReadOnly)){
                    QCryptographicHash hash (QCryptographicHash::Sha512);

                    if (hash.addData(&f)){
                        xmlWriter.writeStartElement("agreements");
                        xmlWriter.writeAttribute("name", txekFile.fileName());
                        xmlWriter.writeAttribute("algorithm", "SHA-512");
                        xmlWriter.writeAttribute("hash", hash.result().toHex());
                        xmlWriter.writeEndElement();
                    }
                }
            }

            // Fitxategi gehigarriak
            if (!query.value("files").toString().isEmpty()){
                QStringListIterator filesItr(query.value("files").toString().split("@@_@@"));
                if (filesItr.hasNext()){
                    xmlWriter.writeStartElement("Files");

                    while (filesItr.hasNext()){
                        fitxategia = filesItr.next();

                        txekFile = QFileInfo(fitxategia);
                        if (txekFile.exists() && txekFile.isFile()){
                            QFile f(fitxategia);

                            if (f.open(QFile::ReadOnly)){
                                QCryptographicHash hash (QCryptographicHash::Sha512);

                                if (hash.addData(&f)){
                                    xmlWriter.writeStartElement("file");
                                    xmlWriter.writeAttribute("name", txekFile.fileName());
                                    xmlWriter.writeAttribute("algorithm", "SHA-512");
                                    xmlWriter.writeAttribute("hash", hash.result().toHex());
                                    xmlWriter.writeEndElement();
                                }
                            }
                        }
                    }

                    xmlWriter.writeEndElement(); // Files
                }
            }
        }
    }

    xmlWriter.writeEndElement(); // LOG

    file.close();
}

/**
 * @brief Log::readLog This method will read log file and fill itemList and AtendeeList with their corresponding elements
 * @param logFilename a QString containing the full path of the log file that has to be read
 * @param itemList a pointer to the list that has to be filled
 * @param atendeeList a pointer to the list that has to be filled
 */
void Log::readLog(QString logFilename,QList <Item> *itemList,QList<Atendee> *atendeeList)
{
    // qdebug()<<"readLog";
    QString filename=logFilename;

    file.setFileName(filename);

    // qdebug()<<"opening log "+filename;
    if(!file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        // qdebug()<<"crash";
    }
    // qdebug()<<"good";
    xmlReader.setDevice(&file);

   /* QList<Item> itemList;
    QList<Atendee> atendeeList;*/

    while(!xmlReader.atEnd() && !xmlReader.hasError()) {
            // Read next element
            QXmlStreamReader::TokenType token = xmlReader.readNext();
            //If token is just StartDocument - go to next
            if(token == QXmlStreamReader::StartDocument) {
                    continue;
            }
            //If token is StartElement - read it
            if(token == QXmlStreamReader::StartElement) {

                    if(xmlReader.name() == "Data") {
                        // qdebug()<<"Find data";
                        while(xmlReader.readNextStartElement())
                        {
                            if(xmlReader.name() == "item") {
                                QString id = xmlReader.attributes().hasAttribute("id") ? xmlReader.attributes().value("id").toString() : "";
                                QString izena = "";

                                Item currentItem;
                                while(xmlReader.readNextStartElement())
                                {
                                     QString item(xmlReader.name().toString());

                                     if(item=="itemName")
                                     {
                                         if (xmlReader.attributes().hasAttribute("language")){
                                             if (QLocale().name().toStdString().compare("es_ES") == 0 && xmlReader.attributes().value("language").toString().compare("es") == 0){
                                                 izena = xmlReader.readElementText();
                                             }
                                             else if (QLocale().name().toStdString().compare("es_ES") != 0 && xmlReader.attributes().value("language").toString().compare("eu") == 0){
                                                 izena = xmlReader.readElementText();
                                             }
                                             else{
                                                 xmlReader.readElementText(); // para que itere....
                                             }
                                         }
                                         else{
                                             izena = xmlReader.readElementText();
                                         }
                                     }
                                     else if (item=="initTime")
                                     {
                                         currentItem.setInitTime(xmlReader.readElementText());

                                     }
                                     else if(item=="endTime")
                                     {
                                         currentItem.setEndTime(xmlReader.readElementText());
                                     }
                                }

                                currentItem.setId(id);
                                currentItem.setName(izena);
                                itemList->append(currentItem);
                            }
                            else if(xmlReader.name() == "speaker") {
                                Atendee currentAtendee;

                                while(xmlReader.readNextStartElement())
                                {
                                     QString item(xmlReader.name().toString());
                                     QString element(xmlReader.readElementText());
                                     if(item=="speakerName")
                                     {
                                        currentAtendee.setName(element);
                                     }
                                     else if (item=="initTime")
                                     {
                                        currentAtendee.setInitTime(element);
                                     }
                                     else if(item=="endTime")
                                     {
                                        currentAtendee.setEndTime(element);
                                     }
                                }
                              //  // qdebug()<<"added atendee "<<currentAtendee.getName();

                                atendeeList->append(currentAtendee);
                                }

                        }

                            continue;
                    }

                    if(xmlReader.name() == "id") {
                        // qdebug() << xmlReader.readElementText();
                    }
            }
    }
    if(xmlReader.hasError()) {
            // qdebug()<<"error";
            file.close();
            return;
    }
    file.close();
}
