#ifndef IZFESINADURA_H
#define IZFESINADURA_H

#include <QObject>
#include <QtNetwork>
#include <QSettings>
#include <QDebug>

#include "nabigatzailea.h"
#include "funtzioak.h"

class izfeSinadura : public QObject
{
    Q_OBJECT
public:
    explicit izfeSinadura(QObject *parent = nullptr);

    void sendRequest(QString file);
signals:

public slots:
    void enableDocumentSending();

signals:
    void tokenReceived();
    void sinaduraEnd(QString egoera, QByteArray erantzuna);
private slots:
    void uploadDone();
    void on_nabigatzaileaItxi();
private:
    QNetworkAccessManager m_networkManager;
    QNetworkReply *m_reply;
    QNetworkReply *m_documentReply;
    QString m_token;
    QString m_redirectUrl;
    QString m_file;
    QFile *m_uploadFile;
    void readRequestResponse();
    void readStatusResponse();
    void readSignatureResponse();
    void sendDocument();

    void prozesuaEnd(QString egoera, QByteArray erantzuna);

    // Garapenerako Url
    //const QString m_apiUrl = "http://desa2.sare.gipuzkoa.net/WAS/HACI/WIZGiltzaRemoteWEB/api/v1/giltza/sign/";

    // Produkziorako Url
    const QString m_apiUrl = "http://w390.sare.gipuzkoa.net/WAS/HACI/WIZGiltzaRemoteWEB/api/v1/giltza/sign/";

    const QString m_callbackUrl = "https://giltza.iametza.eus/";

    const bool DEBUG = true;
    const QString log_file = "sinadura.log";
};

#endif // IZFESINADURA_H
