#include "izfesinadura.h"

izfeSinadura::izfeSinadura(QObject *parent) : QObject(parent)
{
    // Beste signalak prestatu
    connect(this, &izfeSinadura::tokenReceived, this, &izfeSinadura::enableDocumentSending);
}

void izfeSinadura::sendRequest(QString file)
{
    this->m_file = file;
    QFileInfo fileInfo(this->m_file);
    QMimeDatabase mimeDb;
    QMimeType type = mimeDb.mimeTypeForFile(this->m_file);

    QJsonObject jsonObject;
    QJsonObject jsonIdAplicacion;
    QJsonObject jsonAzpidata;
    jsonIdAplicacion["id"] = "UAGAktaGardena";
    jsonAzpidata["fileName"] = fileInfo.fileName();
    jsonObject["callbackUrl"] = this->m_callbackUrl;
    jsonObject["idiomaGiltza"] = "EUSKARA";
    jsonObject["digestAlgorithm"] = "SHA512";
    jsonObject["updateSignature"] = "true";

    if (type.name().compare("application/pdf") == 0){
        jsonObject["signatureProfile"] = "PADES";

        /*QJsonObject jsonPades;
        jsonPades["certificationLevel"] = "NO_CHANGE";
        jsonObject["padesAdditionalInfo"] = jsonPades;*/
    }
    else
        jsonObject["signatureProfile"] = "XADES";

    jsonObject["idAplicacion"] = jsonIdAplicacion;
    jsonObject["data"] = jsonAzpidata;

    QJsonDocument jsonData(jsonObject);

    QString request(this->m_apiUrl + "request");
    QUrl requestUrl(request);
    QNetworkRequest postRequest = QNetworkRequest(requestUrl);
    postRequest.setHeader(QNetworkRequest::ContentTypeHeader, "application/json");
    m_reply = m_networkManager.post(postRequest, jsonData.toJson());
    connect(m_reply, &QNetworkReply::finished, this, &izfeSinadura::readRequestResponse);
}

void izfeSinadura::enableDocumentSending()
{
    izfeSinadura::sendDocument();
}

void izfeSinadura::readRequestResponse()
{
    QJsonParseError jsonParseError;
    QJsonDocument  jsonResponseDocument = QJsonDocument::fromJson(m_reply->readAll(), &jsonParseError);
    if(jsonParseError.error != QJsonParseError::NoError){
        //qDebug() << "jsonParseError: " << jsonParseError.errorString();
        if (this->DEBUG){
            Funtzioak::writeText2File(this->log_file, QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss") + " > readRequestResponse (JSON Parse Error)");
            Funtzioak::writeText2File(this->log_file, "errorString: " + jsonParseError.errorString());
            Funtzioak::writeText2File(this->log_file, "reply error: " + m_reply->errorString());
            Funtzioak::writeText2File(this->log_file, "reply: " + QString::fromStdString(m_reply->readAll().toStdString()));
            Funtzioak::writeText2File(this->log_file, "========================================");
            Funtzioak::writeText2File(this->log_file, "");
        }

        this->prozesuaEnd("bad", tr("Eskaera egiterakoan jasotako formatua ez da egokia.").toUtf8());
        return;
    }

    // objektua lortu konprobazioak egiteko
    QJsonObject jsonResponseObject = jsonResponseDocument.object();
    if(!jsonResponseObject.contains("redirectUrl") || !jsonResponseObject.contains("token")){
        if (this->DEBUG){
            Funtzioak::writeText2File(this->log_file, QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss") + " > readRequestResponse (JSON eremuak faltan)");
            Funtzioak::writeText2File(this->log_file, "JSON: " + QString::fromStdString(jsonResponseDocument.toJson().toStdString()));
            Funtzioak::writeText2File(this->log_file, "========================================");
        }

        this->prozesuaEnd("bad", tr("Eskaera egiterakoan jasotako erantzunean datuak falta dira.").toUtf8());
        return;
    }

    m_token = jsonResponseObject["token"].toString();
    m_redirectUrl = jsonResponseObject["redirectUrl"].toString();

    emit tokenReceived();
}


void izfeSinadura::sendDocument()
{
    QFileInfo fileInfo(this->m_file);
    QMimeDatabase mimeDb;
    QMimeType type = mimeDb.mimeTypeForFile(this->m_file);

    QString urlString(this->m_apiUrl + this->m_token + "/document");
    QUrl url(urlString);

    QHttpMultiPart *multiPart = new QHttpMultiPart(QHttpMultiPart::FormDataType);
    QHttpPart filePart;

    filePart.setHeader(QNetworkRequest::ContentDispositionHeader, QVariant("form-data;  name=\"file\"; filename=\"" + fileInfo.fileName() + "\" "));
    filePart.setHeader(QNetworkRequest::ContentTypeHeader, QVariant(type.name()));
    this->m_uploadFile = new QFile(this->m_file);
    if(!this->m_uploadFile->open(QIODevice::ReadOnly)){
        //qDebug() << "Ezin ireki";
        if (this->DEBUG){
            Funtzioak::writeText2File(this->log_file, QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss") + " > sendDocument (fitxategia ezin ireki)");
            Funtzioak::writeText2File(this->log_file, "fitxategia: " + this->m_file);
            Funtzioak::writeText2File(this->log_file, "========================================");
        }

        this->prozesuaEnd("bad",tr("Ezin izan da ireki sinatu behar den fitxategia.").toUtf8());
        return;
    }
    filePart.setBodyDevice(this->m_uploadFile);
    this->m_uploadFile->setParent(multiPart); // we cannot delete the file now, so delete it with the multiPart

    multiPart->append(filePart);

    QNetworkRequest request(url);
    QNetworkAccessManager *networkManager= new QNetworkAccessManager;
    m_documentReply = networkManager->post(request, multiPart);

    multiPart->setParent(m_documentReply); // delete the multiPart with the reply

    //file->close();

    connect(m_documentReply, SIGNAL(finished()), this, SLOT  (uploadDone()));
}

void izfeSinadura::uploadDone()
{
    this->m_uploadFile->close(); // pijada: si no se queda pillado el fichero y no se puede borrar hasta cerrar el programa....

    if(m_documentReply->error() == QNetworkReply::NoError){
        // ireki nabigatzailea
        Nabigatzailea *nabigatzaileaWidget = new Nabigatzailea(this->m_redirectUrl);
        nabigatzaileaWidget->setCheckUrl(this->m_callbackUrl);
        nabigatzaileaWidget->setAttribute(Qt::WA_DeleteOnClose);
        nabigatzaileaWidget->setWindowModality(Qt::ApplicationModal);
        //nabigatzaileaWidget->setFixedSize(640, 480);
        nabigatzaileaWidget->setMinimumSize(640, 480);
        nabigatzaileaWidget->setWindowState(Qt::WindowMaximized);

        // Mostramos la ventana
        nabigatzaileaWidget->show();

        connect(nabigatzaileaWidget, SIGNAL(nabigatzaileaItxi()), this, SLOT  (on_nabigatzaileaItxi()));
    }
    else{
        if (this->DEBUG){
            Funtzioak::writeText2File(this->log_file, QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss") + " > uploadDone");
            Funtzioak::writeText2File(this->log_file, "errorea: " + m_documentReply->errorString());
            Funtzioak::writeText2File(this->log_file, "========================================");
        }

        this->prozesuaEnd("bad", tr("Sinatu behar den fitxategia bidaltzerakoan errorea.").toUtf8());
    }
}

void izfeSinadura::on_nabigatzaileaItxi()
{
    QString request(this->m_apiUrl + this->m_token + "/status");
    QUrl requestUrl(request);
    QNetworkRequest postRequest = QNetworkRequest(requestUrl);
    postRequest.setHeader(QNetworkRequest::ContentTypeHeader, "application/json");
    m_reply = m_networkManager.get(postRequest);
    connect(m_reply, &QNetworkReply::finished, this, &izfeSinadura::readStatusResponse);
}

void izfeSinadura::readStatusResponse()
{
    QJsonParseError jsonParseError;
    QJsonDocument  jsonResponseDocument = QJsonDocument::fromJson(m_reply->readAll(), &jsonParseError);
    if(jsonParseError.error != QJsonParseError::NoError){
        //qDebug() << "jsonParseError: " << jsonParseError.errorString();
        if (this->DEBUG){
            Funtzioak::writeText2File(this->log_file, QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss") + " > readStatusResponse (jsonParseError)");
            Funtzioak::writeText2File(this->log_file, "errorea: " + jsonParseError.errorString());
            Funtzioak::writeText2File(this->log_file, "========================================");
        }

        this->prozesuaEnd("bad", tr("Erabiltzailearen autentifikazioa egiterakoan jasotako formatua ez da egokia.").toUtf8());
        return;
    }

    // objektua lortu konprobazioak egiteko
    // {"status":"OK","errorDescription":null}
    QJsonObject jsonResponseObject = jsonResponseDocument.object();
    if(!jsonResponseObject.contains("status")){
        //qDebug() << "json error: status key missing";
        if (this->DEBUG){
            Funtzioak::writeText2File(this->log_file, QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss") + " > readStatusResponse (JSON eremuak faltan)");
            Funtzioak::writeText2File(this->log_file, "JSON: " + QString::fromStdString(jsonResponseDocument.toJson().toStdString()));
            Funtzioak::writeText2File(this->log_file, "========================================");
        }

        this->prozesuaEnd("bad", tr("Erabiltzailearen autentifikazioa egiterakoan jasotako erantzunean datuak falta dira.").toUtf8());
        return;
    }

    if (jsonResponseObject["status"].toString().compare("OK") == 0){
        QString request(this->m_apiUrl + this->m_token + "/signature");
        QUrl requestUrl(request);
        QNetworkRequest postRequest = QNetworkRequest(requestUrl);
        postRequest.setHeader(QNetworkRequest::ContentTypeHeader, "application/json");
        m_reply = m_networkManager.get(postRequest);
        connect(m_reply, &QNetworkReply::finished, this, &izfeSinadura::readSignatureResponse);
    }
    else{
        //qDebug() << "autentifikazioa gaizki" << jsonResponseObject["errorDescription"].toString();
        if (this->DEBUG){
            Funtzioak::writeText2File(this->log_file, QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss") + " > readStatusResponse (status != OK)");
            Funtzioak::writeText2File(this->log_file, "status: " + jsonResponseObject["status"].toString());
            Funtzioak::writeText2File(this->log_file, "errorea: " + jsonResponseObject["errorDescription"].toString());
            Funtzioak::writeText2File(this->log_file, "JSON: " + QString::fromStdString(jsonResponseDocument.toJson().toStdString()));
            Funtzioak::writeText2File(this->log_file, "========================================");
        }

        this->prozesuaEnd("bad",tr("Erabiltzailearen autentifikazioan errorea").toUtf8());
    }
}

void izfeSinadura::readSignatureResponse()
{
    if (m_reply->error() == QNetworkReply::NoError)
        this->prozesuaEnd("ok", m_reply->readAll());
    else{
        if (this->DEBUG){
            Funtzioak::writeText2File(this->log_file, QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss") + " > readSignatureResponse");
            Funtzioak::writeText2File(this->log_file, "errorea: " + m_reply->errorString());
            Funtzioak::writeText2File(this->log_file, "========================================");
        }

        this->prozesuaEnd("bad", tr("Sinadura jasotzerakoan errorea.").toUtf8());
    }
}

void izfeSinadura::prozesuaEnd(QString egoera, QByteArray erantzuna)
{
    emit sinaduraEnd(egoera, erantzuna);
}
