#include "item.h"

/**
 * @brief Item::Item Class constructor
 */
Item::Item()
{

}

/**
 * @brief Item::~Item Class destructor
 */
Item::~Item()
{
}

/**
 * @brief Item::setId Method to set the id of an item
 * @param id a QString containing the id
 */
void Item::setId(QString id)
{
    this->id=id;
}

/**
 * @brief Item::getId Method that returns the id of an item
 * @return a QString container the id of the current item
 */
QString Item::getId()
{
    return this->id;
}

/**
 * @brief Item::setName Method to set the name of an item
 * @param name a QString containing the name
 */
void Item::setName(QString name)
{
    this->name=name;
}

/**
 * @brief Item::getName Method that returns the name of an item
 * @return a QString container the name of the current item
 */
QString Item::getName()
{
    return this->name;
}

/**
 * @brief Item::setInitTime Method to set initial time of the item
 * @param initTime initTime QString containing time in hh:mm:ss format (leading zeros)
 */
void Item::setInitTime(QString initTime)
{
    this->initTime=initTime;
    int millisecs=0;
    if(initTime!="NaN")
    {
        millisecs=timeToMillisecs(initTime);
    }
    setInitTimeMillisecs(millisecs);
}

/**
 * @brief Item::getInitTime Method to get
 * @return a QString containing the time in hh:mm:ss format
 */
QString Item::getInitTime()
{
    return this->initTime;
}


/**
 * @brief Item::setEndTime Method to set ending time of the item
 * @param endTime  QString containing time in hh:mm:ss format (leading zeros)
 */
void Item::setEndTime(QString endTime)
{
    this->endTime=endTime;
    int millisecs=0;
    if(endTime!="NaN")
    {
        millisecs=timeToMillisecs(endTime);
    }
    setEndTimeMillisecs(millisecs);
}

QString Item::getEndTime()
{
    return this->endTime;
}

void Item::setInitTimeMillisecs(int millisecs)
{
    this->initTimeMillisecs=millisecs;
}

int Item::getInitTimeMillisecs()
{
    return this->initTimeMillisecs;
}

void Item::setEndTimeMillisecs(int millisecs)
{
    this->endTimeMillisecs=millisecs;
}

int Item::getEndTimeMillisecs()
{
    return this->endTimeMillisecs;
}

int Item::timeToMillisecs(QString time)
{
    QTime currentTime=QTime::fromString(time,"hh:mm:ss");
    int hour=currentTime.hour();
    int minute=currentTime.minute();
    int second=currentTime.second();
    int millisecs=(hour*3600+minute*60+second)*1000;
    return millisecs;
}

QString Item::millisecsToTime(qint64 millisecs)
{
    QTime currentTime= QTime::fromMSecsSinceStartOfDay(millisecs);
    return currentTime.toString("hh:mm:ss");
}
