#ifndef INTERVENTIONMODEL_H
#define INTERVENTIONMODEL_H

#include <QAbstractItemModel>
#include <QModelIndex>
#include <QVariant>
#include <QDebug>
#include <QColor>
#include <QImage>

#include "interventionitem.h"
#include "atendee.h"
#include "item.h"

class InterventionItem;

class InterventionModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    InterventionModel(const QStringList &headers,const QList<Atendee> *list,
              QObject *parent = 0);
    InterventionModel(const QStringList &headers,const QList<Item> *list,
              QObject *parent = 0);
    ~InterventionModel();
    QVariant data(const QModelIndex &index, int role) const override;
    QVariant headerData(int section, Qt::Orientation orientation,
                        int role = Qt::DisplayRole) const override;

    QModelIndex index(int row, int column,
                      const QModelIndex &parent = QModelIndex()) const override;
    QModelIndex parent(const QModelIndex &index) const override;

    int rowCount(const QModelIndex &parent = QModelIndex()) const override;
    int columnCount(const QModelIndex &parent = QModelIndex()) const override;

    QModelIndexList match(const QModelIndex &start, int role, const QVariant &value, int hits = -1, Qt::MatchFlags flags = Qt::MatchContains ) const override;

    Qt::ItemFlags flags(const QModelIndex &index) const override;
    bool setData(const QModelIndex &index, const QVariant &value,
                 int role = Qt::EditRole) override;
    bool setHeaderData(int section, Qt::Orientation orientation,
                       const QVariant &value, int role = Qt::EditRole) override;

    bool insertColumns(int position, int columns,
                       const QModelIndex &parent = QModelIndex()) override;
    bool removeColumns(int position, int columns,
                       const QModelIndex &parent = QModelIndex()) override;
    bool insertRows(int position, int rows,
                    const QModelIndex &parent = QModelIndex()) override;
    bool removeRows(int position, int rows,
                    const QModelIndex &parent = QModelIndex()) override;

    InterventionItem *getItem(const QModelIndex &index) const;
    void setMatchedItems(QModelIndexList matchedItemsList);
    InterventionItem *getRootItem();


private:
    void setupModelData(const QList<Atendee> *list, InterventionItem *parent);
    void setupModelData(const QList<Item> *list, InterventionItem *parent);
    QVariant getIrudia() const;


    InterventionItem *rootItem;
    QModelIndexList matchedItems;
};

#endif // INTERVENTIONMODEL_H
