#include "interventionmodel.h"

InterventionModel::InterventionModel(const QStringList &headers, const QList<Atendee> *list, QObject *parent)
    : QAbstractItemModel(parent)
{
    QVector<QVariant> rootData;
    foreach (QString header, headers)
        rootData << header;

    rootItem = new InterventionItem(rootData);
    matchedItems = QModelIndexList();
    setupModelData(list, rootItem);
}

InterventionModel::InterventionModel(const QStringList &headers, const QList<Item> *list, QObject *parent)
    : QAbstractItemModel(parent)
{
    QVector<QVariant> rootData;
    foreach (QString header, headers)
        rootData << header;

    rootItem = new InterventionItem(rootData);
    matchedItems = QModelIndexList();
    setupModelData(list, rootItem);
}

InterventionModel::~InterventionModel()
{
    delete rootItem;
}

int InterventionModel::columnCount(const QModelIndex & /* parent */) const
{
    return rootItem->columnCount();
}


QModelIndexList InterventionModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, Qt::MatchFlags flags) const
{

    int curTime = value.toInt();
    int interventionStartTime;
    int interventionEndTime;
    QModelIndexList list = QModelIndexList();
    QModelIndex in = index(0, 0);
    QModelIndex itemIndex0;
    QModelIndex itemIndex1;
    QModelIndex itemIndex2;
    QModelIndex itemIndex5;

    if(in.isValid()) {
        InterventionItem *item;

        for(int curIndex = 0; curIndex < rootItem->childCount() ; curIndex++){
            itemIndex0 = index(curIndex, 0);
            itemIndex1 = index(curIndex, 1);
            itemIndex2 = index(curIndex, 2);
            itemIndex5 = index(curIndex, 5);

            item = getItem(itemIndex0);
            interventionStartTime = item->data(3).toInt();
            interventionEndTime = item->data(4).toInt();
            if(curTime >= interventionStartTime && curTime <= interventionEndTime){
                list.append(itemIndex0);
                list.append(itemIndex1);
                list.append(itemIndex2);
                list.append(itemIndex5);
            }
        }
    }

    return list;
}


QVariant InterventionModel::data(const QModelIndex &index, int role) const
{
    if (!index.isValid())
        return QVariant();

    if (role == Qt::BackgroundRole)
    {
        if (matchedItems.contains(index)){
            return QColor(148, 192, 38);
        }
        else{
            return QColor(Qt::white);
        }
    }
    else if (role == Qt::DecorationRole && index.column() == 5)
    {
        if (matchedItems.contains(index))
            return getIrudia();
        else
            return "";
    }

    if (role != Qt::DisplayRole && role != Qt::EditRole)
        return QVariant();

    InterventionItem *item = getItem(index);

    return item->data(index.column());
}


Qt::ItemFlags InterventionModel::flags(const QModelIndex &index) const
{
    if (!index.isValid())
        return 0;

    return QAbstractItemModel::flags(index);
}

InterventionItem *InterventionModel::getItem(const QModelIndex &index) const
{
    if (index.isValid()) {
        InterventionItem *item = static_cast<InterventionItem*>(index.internalPointer());
        if (item)
            return item;
    }
    return rootItem;
}


QVariant InterventionModel::headerData(int section, Qt::Orientation orientation,
                               int role) const
{
    if (orientation == Qt::Horizontal && role == Qt::DisplayRole)
        return rootItem->data(section);

    return QVariant();
}


QModelIndex InterventionModel::index(int row, int column, const QModelIndex &parent) const
{
    if (parent.isValid() && parent.column() != 0)
        return QModelIndex();

    InterventionItem *parentItem = getItem(parent);

    InterventionItem *childItem = parentItem->child(row);
    if (childItem){
        return createIndex(row, column, childItem);
    }
    return QModelIndex();
}


bool InterventionModel::insertColumns(int position, int columns, const QModelIndex &parent)
{
    bool success;

    beginInsertColumns(parent, position, position + columns - 1);
    success = rootItem->insertColumns(position, columns);
    endInsertColumns();

    return success;
}

bool InterventionModel::insertRows(int position, int rows, const QModelIndex &parent)
{
    InterventionItem *parentItem = getItem(parent);
    bool success;

    beginInsertRows(parent, position, position + rows - 1);
    success = parentItem->insertChildren(position, rows, parentItem->columnCount()); // TODO Hau aldatu
    endInsertRows();

    return success;
}


QModelIndex InterventionModel::parent(const QModelIndex &index) const
{
    if (!index.isValid())
        return QModelIndex();

    InterventionItem *childItem = getItem(index);
    InterventionItem *parentItem = childItem->parent();

    if (parentItem == rootItem)
        return QModelIndex();

    return createIndex(parentItem->childNumber(), 0, parentItem);
}


bool InterventionModel::removeColumns(int position, int columns, const QModelIndex &parent)
{
    bool success;

    beginRemoveColumns(parent, position, position + columns - 1);
    success = rootItem->removeColumns(position, columns);
    endRemoveColumns();

    if (rootItem->columnCount() == 0)
        removeRows(0, rowCount());

    return success;
}

bool InterventionModel::removeRows(int position, int rows, const QModelIndex &parent)
{
    InterventionItem *parentItem = getItem(parent);
    bool success = true;

    beginRemoveRows(parent, position, position + rows - 1);
    success = parentItem->removeChildren(position, rows);
    endRemoveRows();

    return success;
}

void InterventionModel::setMatchedItems(QModelIndexList matchedItemsList)
{
    matchedItems = matchedItemsList;

    for(int i = 0; i < rootItem->childCount() ; i++){
        emit dataChanged(index(i, 0), index(i, 0));
        emit dataChanged(index(i, 1), index(i, 1));
        emit dataChanged(index(i, 2), index(i, 2));
        emit dataChanged(index(i, 5), index(i, 5));
    }

}

InterventionItem *InterventionModel::getRootItem()
{
    return rootItem;
}

//! [8]
int InterventionModel::rowCount(const QModelIndex &parent) const
{
    InterventionItem *parentItem = getItem(parent);

    return parentItem->childCount();
}
//! [8]

bool InterventionModel::setData(const QModelIndex &index, const QVariant &value, int role)
{
    if (role != Qt::EditRole)
        return false;

    InterventionItem *item = getItem(index);
    bool result = item->setData(index.column(), value);

    if (result)
        emit dataChanged(index, index);

    return result;
}

bool InterventionModel::setHeaderData(int section, Qt::Orientation orientation,
                              const QVariant &value, int role)
{
    if (role != Qt::EditRole || orientation != Qt::Horizontal)
        return false;

    bool result = rootItem->setData(section, value);

    if (result)
        emit headerDataChanged(orientation, section, section);

    return result;
}

void InterventionModel::setupModelData(const QList<Atendee> *list, InterventionItem *parent)
{
    QList<InterventionItem*> parents;
    QList<int> indentations;
    parents << parent;
    indentations << 0;
    Atendee atendee_tmp;

    /// Initialize Atendees
    QListIterator<Atendee> extendedAtendeeIterator(*list);
    while(extendedAtendeeIterator.hasNext())
     {
         atendee_tmp = extendedAtendeeIterator.next();
         // qdebug() << atendee_tmp.getName();
         InterventionItem *parent = parents.last();
         parent->insertChildren(parent->childCount(), 1, rootItem->columnCount());

         parent->child(parent->childCount() - 1)->setData(0, atendee_tmp.getName());
         parent->child(parent->childCount() - 1)->setData(1, atendee_tmp.getInitTime());
         parent->child(parent->childCount() - 1)->setData(2, atendee_tmp.getEndTime());
         parent->child(parent->childCount() - 1)->setData(3, atendee_tmp.getInitTimeMillisecs());
         parent->child(parent->childCount() - 1)->setData(4, atendee_tmp.getEndTimeMillisecs());
     }

}

void InterventionModel::setupModelData(const QList<Item> *list, InterventionItem *parent)
{
    QList<InterventionItem*> parents;
    QList<int> indentations;
    parents << parent;
    indentations << 0;
    Item item_tmp;

    /// Initialize Item
    QListIterator<Item> extendedItemIterator(*list);
    while(extendedItemIterator.hasNext())
     {
         item_tmp = extendedItemIterator.next();
         // qdebug() << item_tmp.getName();
         InterventionItem *parent = parents.last();
         parent->insertChildren(parent->childCount(), 1, rootItem->columnCount());

         parent->child(parent->childCount() - 1)->setData(0, item_tmp.getName());
         parent->child(parent->childCount() - 1)->setData(1, item_tmp.getInitTime());
         parent->child(parent->childCount() - 1)->setData(2, item_tmp.getEndTime());
         parent->child(parent->childCount() - 1)->setData(3, item_tmp.getInitTimeMillisecs());
         parent->child(parent->childCount() - 1)->setData(4, item_tmp.getEndTimeMillisecs());
         parent->child(parent->childCount() - 1)->setData(6, item_tmp.getId());
     }

}

QVariant InterventionModel::getIrudia() const
{
    return QImage(":/images/mikrofonoa.png");
}
