#ifndef INTERVENTIONITEM_H
#define INTERVENTIONITEM_H

#include <QList>
#include <QVariant>
#include <QVector>
#include <QDebug>

class InterventionItem
{
public:
    explicit InterventionItem(const QVector<QVariant> &data, InterventionItem *parent = 0);
    ~InterventionItem();

    InterventionItem *child(int number);
    int childCount() const;
    int columnCount() const;
    QVariant data(int column) const;
    bool insertChildren(int position, int count, int columns);
    bool insertColumns(int position, int columns);
    InterventionItem *parent();
    bool removeChildren(int position, int count);
    bool removeColumns(int position, int columns);
    int childNumber() const;
    bool setData(int column, const QVariant &value);

private:
    QList<InterventionItem*> childItems;
    QVector<QVariant> itemData;
    InterventionItem *parentItem;
};

#endif // INTERVENTIONITEM_H
