#include "interventionitem.h"

#include <QStringList>


InterventionItem::InterventionItem(const QVector<QVariant> &data, InterventionItem *parent)
{
    parentItem = parent;
    itemData = data;
}

InterventionItem::~InterventionItem()
{
    qDeleteAll(childItems);
}

InterventionItem *InterventionItem::child(int number)
{
    return childItems.value(number);
}

int InterventionItem::childCount() const
{
    return childItems.count();
}

int InterventionItem::childNumber() const
{
    if (parentItem)
        return parentItem->childItems.indexOf(const_cast<InterventionItem*>(this));

    return 0;
}

int InterventionItem::columnCount() const
{
    return itemData.count();
}

QVariant InterventionItem::data(int column) const
{
    return itemData.value(column);
}

bool InterventionItem::insertChildren(int position, int count, int columns)
{
    if (position < 0 || position > childItems.size())
        return false;

    for (int row = 0; row < count; ++row) {
        QVector<QVariant> data(columns);
        data.reserve(columns);
        InterventionItem *item = new InterventionItem(data, this);
        childItems.insert(position, item);
    }

    return true;
}

bool InterventionItem::insertColumns(int position, int columns)
{
    if (position < 0 || position > itemData.size())
        return false;

    for (int column = 0; column < columns; ++column)
        itemData.insert(position, QVariant());

    foreach (InterventionItem *child, childItems)
        child->insertColumns(position, columns);

    return true;
}

InterventionItem *InterventionItem::parent()
{
    return parentItem;
}

bool InterventionItem::removeChildren(int position, int count)
{
    if (position < 0 || position + count > childItems.size())
        return false;

    for (int row = 0; row < count; ++row)
        delete childItems.takeAt(position);

    return true;
}


bool InterventionItem::removeColumns(int position, int columns)
{
    if (position < 0 || position + columns > itemData.size())
        return false;

    for (int column = 0; column < columns; ++column)
        itemData.remove(position);

    foreach (InterventionItem *child, childItems)
        child->removeColumns(position, columns);

    return true;
}


bool InterventionItem::setData(int column, const QVariant &value)
{
    if (column < 0 || column >= itemData.count())
        return false;
    itemData.replace(column, value);

    return true;
}
