#include "funtzioak.h"

qint64 gako = Q_INT64_C(719426002635201);

Funtzioak::Funtzioak()
{
}

QString Funtzioak::getTxurroThemeIzena(QString txurro, bool fromDB)
{
    static DbManager db;

    if (txurro.contains("##_##")){
        QStringList txurroList(txurro.split("##_##"));
        if (txurroList.length() == 2){
            if (fromDB){
                if (db.isOpen()){
                    QSqlQuery query;

                    query.prepare("SELECT * FROM theme WHERE id=:id");
                    query.bindValue(":id", txurroList.value(0));
                    query.exec();

                    query.first();
                    if (query.isValid()){
                        return (QLocale().name().toStdString().compare("es_ES") == 0 ? query.value("izena_es").toString() : query.value("izena").toString());
                    }
                }
            }

            return (txurroList.value(1));
        }
    }

    return (txurro);
}

QString Funtzioak::getTxurroThemeId(QString txurro)
{
    if (txurro.contains("##_##")){
        QStringList txurroList(txurro.split("##_##"));
        if (txurroList.length() == 2){
            return (txurroList.value(0));
        }
    }

    return ("0");
}

QString Funtzioak::getSignedFileName(int record_id, QString zein)
{
    static DbManager db;
    QString sinadura_izena = "";
    QString ext = "";

    if (db.isOpen()){
        QSqlQuery query;

        query.prepare("SELECT * FROM record WHERE id=:recordId");
        query.bindValue(":recordId", record_id);
        query.exec();

        query.first();
        if (query.isValid()){

            if (zein.compare("akta") == 0){
                sinadura_izena = query.value("fileName").toString();
                ext = "xml";
            }
            else if (zein.compare("erabakiak") == 0){
                // aunque ahora siempre se llame "acuerdos_adoptados.pdf"....
                QFileInfo fileInfo(query.value("erabakiakFile").toString());

                sinadura_izena = fileInfo.baseName();
                ext = fileInfo.completeSuffix();
            }

        }
    }

    return (!sinadura_izena.isEmpty() ? sinadura_izena + "_sinadura." + ext : "");
}

QString Funtzioak::encrypt(QString testua)
{
    SimpleCrypt crypto(gako);

    return crypto.encryptToString(testua);
}

QString Funtzioak::decrypt(QString testua)
{
    SimpleCrypt crypto(gako);

    return crypto.decryptToString(testua);
}

QString Funtzioak::loadPublishConf()
{
    QString ftp_server, ftp_port, ftp_user, ftp_pass;
    QStringList loaded;

    QSettings settings("bideoakta", "iametza");

    // Aktak publikatzeko beharrezko konfigurazio datuak fitxategi zehatz batetik kargatzen dira.
    QFile fitx(QDir::homePath() + "/ag.conf");
    if (fitx.exists()){
        if (fitx.open(QIODevice::ReadOnly)){
            QTextStream in(&fitx);

            while(!in.atEnd()){
                QString line = in.readLine();

                // Entitatearen kodea zuzenean kargatu
                if (line.section('=', 0, 0).compare("entity_code") == 0 && !line.section('=', 1).isEmpty()){
                    settings.setValue("entity_code", line.section('=', 1));

                    loaded.append(QObject::tr("entity code"));
                }
                else if (line.section('=', 0, 0).compare("ftp_server") == 0 && !line.section('=', 1).isEmpty()){
                    ftp_server = line.section('=', 1);
                }
                else if (line.section('=', 0, 0).compare("ftp_port") == 0 && !line.section('=', 1).isEmpty()){
                    ftp_port = line.section('=', 1);
                }
                else if (line.section('=', 0, 0).compare("ftp_user") == 0 && !line.section('=', 1).isEmpty()){
                    ftp_user = line.section('=', 1);
                }
                else if (line.section('=', 0, 0).compare("ftp_pass") == 0 && !line.section('=', 1).isEmpty()){
                    ftp_pass = line.section('=', 1);
                }
            }

            // FTP datuak kargatu
            if(!ftp_server.isEmpty() && !ftp_user.isEmpty() && !ftp_pass.isEmpty()){
                settings.setValue("ftp_server", ftp_server);
                settings.setValue("ftp_port", ftp_port);
                settings.setValue("ftp_user", ftp_user);
                settings.setValue("ftp_pass", Funtzioak::encrypt(ftp_pass));

                loaded.append(QObject::tr("ftp configuration"));
            }

            fitx.close();
        }
    }

    return QObject::tr("Ready") + (loaded.count() > 0 ? " (" + QObject::tr("loaded") + ": " + loaded.join(", ") + ")" : "");
}

void Funtzioak::writeText2File(QString fileName, QString text)
{
    QSettings settings("bideoakta", "iametza");
    QString path = QDir::homePath();

    if (settings.contains("data_folder") && QDir(settings.value("data_folder").toString()).exists()){
        path = settings.value("data_folder").toString();
    }

    QFile file(path + "/" + fileName);

    if (file.open(QIODevice::WriteOnly | QIODevice::Append | QIODevice::Text)){
        //file.write(text.toLocal8Bit().data());
        QTextStream stream(&file);

        stream << text << endl;

        file.close();
    }
}
