#include "foldersettings.h"
#include "ui_foldersettings.h"

FolderSettings::FolderSettings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FolderSettings)
{
    ui->setupUi(this);

    setFixedSize (420, 150);

    QSettings settings("bideoakta", "iametza");
    if (!settings.contains("data_folder")){
        // Guardamos los valores por defecto en "settings"
        settings.setValue("data_folder", QDir::homePath());
    }

    ui->dataFolderLabel->setText(settings.value("data_folder").toString());
}

FolderSettings::~FolderSettings()
{
    delete ui;
}

void FolderSettings::on_pushButton_clicked()
{
    QString dir = QFileDialog::getExistingDirectory ( this, tr("Open Directory"),NULL, QFileDialog::ShowDirsOnly );
    QFileInfo my_dir(dir);
    if(my_dir.isWritable()!=true)
    {
        QMessageBox msgBox;
        msgBox.setText("Directory not writable");
        msgBox.setInformativeText("Folder cannot be written.");
        msgBox.setStandardButtons(QMessageBox::Ok);
        msgBox.exec();
    }
    else
    {
        ui->dataFolderLabel->setText(dir);
    }
}

void FolderSettings::on_okBotoia_clicked()
{
    QSettings settings("bideoakta", "iametza");
    settings.setValue("data_folder", ui->dataFolderLabel->text());

    close ();
}

void FolderSettings::on_cancelBotoia_clicked()
{
    close ();
}

void FolderSettings::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close ();
}
