#ifndef EDITTHEME_H
#define EDITTHEME_H

#include <QWidget>
#include <QDebug>
#include <QtSql>
#include <QMessageBox>
#include <QKeyEvent>

#include "dbmanager.h"

namespace Ui {
class editTheme;
}

class editTheme : public QWidget
{
    Q_OBJECT

public:
    explicit editTheme(QWidget *parent = 0);
    ~editTheme();

private slots:

    void on_gehituBotoia_clicked();
    void on_gehituTestua_returnPressed();
    void on_ezabatuBotoia_clicked();

    void onDataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight);

    void on_gehituTestuaEs_returnPressed();

protected:
    bool eventFilter(QObject *obj, QEvent *ev);

private:
    Ui::editTheme *ui;

    QSqlRelationalTableModel *modeloa;

    DbManager db;

    void keyPressEvent(QKeyEvent *keyEvent);
    void showError(const QSqlError &err);
};

#endif // EDITTHEME_H
