#include "edittheme.h"
#include "ui_edittheme.h"

editTheme::editTheme(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::editTheme)
{
    ui->setupUi(this);

    if (db.isOpen()){
        modeloa = new QSqlRelationalTableModel(ui->zerrenda);
        modeloa->setEditStrategy(QSqlTableModel::OnFieldChange);
        modeloa->setTable("theme");

        modeloa->setHeaderData(modeloa->fieldIndex("izena"), Qt::Horizontal, tr("Gaia") + " (eu)");
        modeloa->setHeaderData(modeloa->fieldIndex("izena_es"), Qt::Horizontal, tr("Gaia") + " (es)");

        // Populate the model
        if (!modeloa->select()) {
            showError(modeloa->lastError());
            return;
        }

        ui->zerrenda->setModel(modeloa);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("id"), true);
        ui->zerrenda->horizontalHeader()->setStretchLastSection(true);
        ui->zerrenda->setSortingEnabled(true);
        ui->zerrenda->sortByColumn(1, Qt::AscendingOrder);
        ui->zerrenda->installEventFilter(this);

        //connect (modeloa, SIGNAL(dataChanged(const QModelIndex&, const QModelIndex&)), this, SLOT(onDataChanged(const QModelIndex&, const QModelIndex&)));
    }

    setWindowTitle(tr("Edit Theme"));

    setFixedSize (400, 330);
}

editTheme::~editTheme()
{
    delete ui;
}

void editTheme::on_gehituBotoia_clicked()
{
    QString izena = !ui->gehituTestua->text().isEmpty() ? ui->gehituTestua->text() : ui->gehituTestuaEs->text();
    QString izena_es = !ui->gehituTestuaEs->text().isEmpty() ? ui->gehituTestuaEs->text() : ui->gehituTestua->text();

    if (db.isOpen() && !izena.isEmpty()){

        QSqlQuery queryAdd;
        queryAdd.prepare("INSERT INTO theme (izena, izena_es) VALUES (:izena, :izena_es)");
        queryAdd.bindValue(":izena", izena);
        queryAdd.bindValue(":izena_es", izena_es);

        if(queryAdd.exec())
        {
            ui->gehituTestua->setText("");
            ui->gehituTestuaEs->setText("");

            if (!modeloa->select()) {
                showError(modeloa->lastError());
                return;
            }
        }
        else
        {
            // qdebug() << "add theme failed: " << queryAdd.lastError();
        }

    }

}

void editTheme::on_gehituTestua_returnPressed()
{
    on_gehituBotoia_clicked();
}

void editTheme::on_ezabatuBotoia_clicked()
{
    QItemSelection selection(ui->zerrenda->selectionModel()->selection());

    QList<int> rows;
    foreach (const QModelIndex & index, selection.indexes()){
        rows.append (index.row());
    }

    qSort (rows);

    if (rows.count() > 0){
        QMessageBox msgBox;
        msgBox.setWindowTitle(tr("Konfirmazioa"));
        msgBox.setText(tr("Ezabatzea aukeratu duzu. Ziur al zaude?"));
        msgBox.setIcon(QMessageBox::Question);
        msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        msgBox.setDefaultButton(QMessageBox::Cancel);
        int ret = msgBox.exec();

        switch (ret) {
          case QMessageBox::Ok:
            int prev = -1;
            for (int i = rows.count() - 1; i >= 0; i -= 1 ){
                int current = rows[i];
                if (current != prev){
                    modeloa->removeRows(current, 1);
                    prev = current;
                }
            }

            if (rows.count() > 0){

                if (!modeloa->select()) {
                    showError(modeloa->lastError());
                    return;
                }
            }

            break;
        }
    }
}

void editTheme::onDataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
{
    modeloa->submitAll();

    if (!modeloa->select()) {
        showError(modeloa->lastError());
        return;
    }
}

bool editTheme::eventFilter(QObject *object, QEvent *event)
{
    if (object == ui->zerrenda) {

        if (event->type() == QEvent::KeyPress) {

            QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            switch(keyEvent->key()) {
                case Qt::Key_Delete:
                    on_ezabatuBotoia_clicked();
                    break;
                case Qt::Key_Escape:
                    close();
                    break;
            }

            return true;

        }
        else {
            return false;
        }

    }
    else {
        return QWidget::eventFilter(object, event);
    }
}

void editTheme::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close();
}

void editTheme::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}

void editTheme::on_gehituTestuaEs_returnPressed()
{
    on_gehituBotoia_clicked();
}
