#ifndef EDITSESSIONTYPE_H
#define EDITSESSIONTYPE_H

#include <QWidget>
#include <QDebug>
#include <QtSql>
#include <QMessageBox>
#include <QKeyEvent>
#include <QCloseEvent>

#include "dbmanager.h"

namespace Ui {
class editSessionType;
}

class editSessionType : public QWidget
{
    Q_OBJECT

public:
    explicit editSessionType(QWidget *parent = 0);
    ~editSessionType();

    void closeEvent(QCloseEvent *event);

private slots:

    void on_gehituBotoia_clicked();
    void on_gehituTestua_returnPressed();
    void on_ezabatuBotoia_clicked();

    void onDataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight);

protected:
    bool eventFilter(QObject *obj, QEvent *ev);

private:
    Ui::editSessionType *ui;

    QSqlRelationalTableModel *modeloa;
    QSortFilterProxyModel *proxyModeloa;

    DbManager db;

    void keyPressEvent(QKeyEvent *keyEvent);
    void showError(const QSqlError &err);

signals:
    void sessionTypeKargatu();

};

#endif // EDITSESSIONTYPE_H
