#include "editsessiontype.h"
#include "ui_editsessiontype.h"

editSessionType::editSessionType(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::editSessionType)
{
    ui->setupUi(this);

    if (db.isOpen()){
        modeloa = new QSqlRelationalTableModel(ui->zerrenda);
        modeloa->setEditStrategy(QSqlTableModel::OnFieldChange);
        modeloa->setTable("session_type");
        modeloa->setHeaderData(modeloa->fieldIndex("izena"), Qt::Horizontal, tr("Izena"));
        //modeloa->setSort(1, Qt::AscendingOrder);

        // Populate the model
        if (!modeloa->select()) {
            showError(modeloa->lastError());
            return;
        }

        ui->zerrenda->setModel(modeloa);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("id"), true);
        ui->zerrenda->horizontalHeader()->setStretchLastSection(true);
        ui->zerrenda->setSortingEnabled(true);
        ui->zerrenda->sortByColumn(1, Qt::AscendingOrder);
        ui->zerrenda->installEventFilter(this);

        connect (modeloa, SIGNAL(dataChanged(const QModelIndex&, const QModelIndex&)), this, SLOT(onDataChanged(const QModelIndex&, const QModelIndex&)));
    }

    setWindowTitle(tr("Edit Session type"));

    setFixedSize (400, 330);
}

editSessionType::~editSessionType()
{
    delete ui;
}

void editSessionType::on_gehituBotoia_clicked()
{
    QString izena=ui->gehituTestua->text();

    if (db.isOpen() && !izena.isEmpty()){

        QSqlQuery queryAdd;
        queryAdd.prepare("INSERT INTO session_type (izena) VALUES (:izena)");
        queryAdd.bindValue(":izena", izena);

        if(queryAdd.exec())
        {
            ui->gehituTestua->setText("");

            if (!modeloa->select()) {
                showError(modeloa->lastError());
                return;
            }
        }
        else
        {
            // qdebug() << "add session type failed: " << queryAdd.lastError();
        }

    }

}

void editSessionType::on_gehituTestua_returnPressed()
{
    on_gehituBotoia_clicked();
}

void editSessionType::on_ezabatuBotoia_clicked()
{
    QItemSelection selection(ui->zerrenda->selectionModel()->selection());

    QList<int> rows;
    foreach (const QModelIndex & index, selection.indexes()){
        rows.append (index.row());
    }

    qSort (rows);

    if (rows.count() > 0){
        QMessageBox msgBox;
        msgBox.setWindowTitle(tr("Konfirmazioa"));
        msgBox.setText(tr("Ezabatzea aukeratu duzu. Ziur al zaude?"));
        msgBox.setIcon(QMessageBox::Question);
        msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        msgBox.setDefaultButton(QMessageBox::Cancel);
        int ret = msgBox.exec();

        switch (ret) {
          case QMessageBox::Ok:
            int prev = -1;
            for (int i = rows.count() - 1; i >= 0; i -= 1 ){
                int current = rows[i];
                if (current != prev){
                    modeloa->removeRows(current, 1);
                    prev = current;
                }
            }

            if (!modeloa->select()) {
                showError(modeloa->lastError());
                return;
            }

            break;
        }
    }
}

void editSessionType::onDataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
{
    /*if (!modeloa->submitAll()) {
        showError(modeloa->lastError());
        return;
    }*/

    /*if (!modeloa->select()) {
        showError(modeloa->lastError());
        return;
    }*/

    // qdebug() << "dataChanged" << topLeft.row() << topLeft.column() << bottomRight.row() << bottomRight.column();

    //if (topLeft.row() == bottomRight.row() && topLeft.column() == bottomRight.column()){

    // qdebug() << modeloa->data(topLeft) << modeloa->data(bottomRight);

    //modeloa->sort(1, Qt::AscendingOrder);
}

bool editSessionType::eventFilter(QObject *object, QEvent *event)
{
    if (object == ui->zerrenda) {

        if (event->type() == QEvent::KeyPress) {

            QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            switch(keyEvent->key()) {
                case Qt::Key_Delete:
                    on_ezabatuBotoia_clicked();
                    break;
                case Qt::Key_Escape:
                    close();
                break;
            }

            return true;

        }
        else {
            return false;
        }

    }
    else {
        return QWidget::eventFilter(object, event);
    }
}

void editSessionType::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close();
}

void editSessionType::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}

void editSessionType::closeEvent(QCloseEvent *event)
{
    emit sessionTypeKargatu();
}
