#ifndef EDITROL_H
#define EDITROL_H

#include <QWidget>
#include <QDebug>
#include <QtSql>
#include <QMessageBox>
#include <QKeyEvent>

#include "dbmanager.h"

namespace Ui {
class editRol;
}

class editRol : public QWidget
{
    Q_OBJECT

public:
    explicit editRol(QWidget *parent = 0);
    ~editRol();

private slots:

    void on_gehituBotoia_clicked();
    void on_gehituTestua_returnPressed();
    void on_ezabatuBotoia_clicked();

    void onDataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight);

protected:
    bool eventFilter(QObject *obj, QEvent *ev);

private:
    Ui::editRol *ui;

    QSqlRelationalTableModel *modeloa;
    QSortFilterProxyModel *proxyModeloa;

    DbManager db;

    void keyPressEvent(QKeyEvent *keyEvent);
    void showError(const QSqlError &err);
};

#endif // EDITROL_H
