#include "editrol.h"
#include "ui_editrol.h"

editRol::editRol(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::editRol)
{
    ui->setupUi(this);

    if (db.isOpen()){
        modeloa = new QSqlRelationalTableModel(ui->zerrenda);
        modeloa->setEditStrategy(QSqlTableModel::OnFieldChange);
        modeloa->setTable("rol");

        modeloa->setHeaderData(modeloa->fieldIndex("izena"), Qt::Horizontal, tr("Izena"));

        // Populate the model
        if (!modeloa->select()) {
            showError(modeloa->lastError());
            return;
        }

        ui->zerrenda->setModel(modeloa);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("id"), true);
        ui->zerrenda->horizontalHeader()->setStretchLastSection(true);
        ui->zerrenda->setSortingEnabled(true);
        ui->zerrenda->sortByColumn(1, Qt::AscendingOrder);
        ui->zerrenda->installEventFilter(this);

        //connect (modeloa, SIGNAL(dataChanged(const QModelIndex&, const QModelIndex&)), this, SLOT(onDataChanged(const QModelIndex&, const QModelIndex&)));
    }

    setWindowTitle(tr("Edit Rol"));

    setFixedSize (400, 330);
}

editRol::~editRol()
{
    delete ui;
}

void editRol::on_gehituBotoia_clicked()
{
    QString izena=ui->gehituTestua->text();

    if (db.isOpen() && !izena.isEmpty()){

        QSqlQuery queryAdd;
        queryAdd.prepare("INSERT INTO rol (izena) VALUES (:izena)");
        queryAdd.bindValue(":izena", izena);

        if(queryAdd.exec())
        {
            ui->gehituTestua->setText("");

            if (!modeloa->select()) {
                showError(modeloa->lastError());
                return;
            }
        }
        else
        {
            // qdebug() << "add rol failed: " << queryAdd.lastError();
        }

    }
}

void editRol::on_gehituTestua_returnPressed()
{
    on_gehituBotoia_clicked();
}

void editRol::on_ezabatuBotoia_clicked()
{
    QItemSelection selection(ui->zerrenda->selectionModel()->selection());

    QList<int> rows;
    foreach (const QModelIndex & index, selection.indexes()){
        rows.append (index.row());
    }

    qSort (rows);

    if (rows.count() > 0){
        QMessageBox msgBox;
        msgBox.setWindowTitle(tr("Konfirmazioa"));
        msgBox.setText(tr("Ezabatzea aukeratu duzu. Ziur al zaude?"));
        msgBox.setIcon(QMessageBox::Question);
        msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        msgBox.setDefaultButton(QMessageBox::Cancel);
        int ret = msgBox.exec();

        switch (ret) {
          case QMessageBox::Ok:
            int prev = -1;
            for (int i = rows.count() - 1; i >= 0; i -= 1 ){
                int current = rows[i];
                if (current != prev){
                    modeloa->removeRows(current, 1);
                    prev = current;
                }
            }

            if (rows.count() > 0){

                if (!modeloa->select()) {
                    showError(modeloa->lastError());
                    return;
                }
            }

            break;
        }
    }
}

void editRol::onDataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
{
    modeloa->submitAll();

    if (!modeloa->select()) {
        showError(modeloa->lastError());
        return;
    }
}

bool editRol::eventFilter(QObject *object, QEvent *event)
{
    if (object == ui->zerrenda) {

        if (event->type() == QEvent::KeyPress) {

            QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            switch(keyEvent->key()) {
                case Qt::Key_Delete:
                    on_ezabatuBotoia_clicked();
                    break;
                case Qt::Key_Escape:
                    close();
                break;
            }

            return true;

        }
        else {
            return false;
        }

    }
    else {
        return QWidget::eventFilter(object, event);
    }
}

void editRol::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close();
}

void editRol::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}
