#include "editnotedialog.h"
#include "ui_editnotedialog.h"

editNoteDialog::editNoteDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::editNoteDialog)
{
    ui->setupUi(this);

    ui->timeEdit->setInputMask("99:99:99");
    ui->timeEdit->setCursorPosition(0);

    QRegExp timeRegExp("^(?:(?:([01]?\\d|2[0-3]):)?([0-5]?\\d):)?([0-5]?\\d)$");
    QValidator *validator = new QRegExpValidator(timeRegExp);
    ui->timeEdit->setValidator(validator);

    setFixedSize(640, 200);
}

editNoteDialog::~editNoteDialog()
{
    delete ui;
}

void editNoteDialog::setData(QString noiz, QString testua, int maxTime, bool isNew)
{
    m_noiz = noiz;
    m_testua = testua;
    m_maxTime = maxTime;
    m_isNew = isNew;

    if (m_isNew){
        ui->ezabatuButton->setVisible(false);

        this->setWindowTitle(tr("New note"));
    }
    else{
        this->setWindowTitle(tr("Edit note"));
    }

    ui->timeEdit->setText(m_noiz);
    ui->noteEdit->setText(m_testua);
}

QString editNoteDialog::getNoiz()
{
    return (ui->timeEdit->text());
}

QString editNoteDialog::getTestua()
{
    return (ui->noteEdit->text());
}

void editNoteDialog::on_ezabatuButton_clicked()
{
    emit deleteClicked();
}
