#ifndef EDITINTERVENTIONDIALOG_H
#define EDITINTERVENTIONDIALOG_H

#include <QDialog>
#include <QMessageBox>
#include <QDebug>

#include "item.h"
#include "atendee.h"


namespace Ui {
class editInterventionDialog;
}

class EditInterventionDialog : public QDialog
{
    Q_OBJECT

public:
    explicit EditInterventionDialog(QWidget *parent = 0);
    ~EditInterventionDialog();
    void setType(QString type, QList<Atendee> list, bool isNew);
    void setType(QString type, QList<Item> list, bool isNew);
    void setData(int startTime, int endTime, int maxTime, QString name="");
    void setData(QString startTime, QString endTime, int maxTime, QString name="");
    QString getType();
    QString getName();
    qint64 getStartTime();
    qint64 getEndTime();
    QString getId();

    bool getIsNew();
signals:
    void deleteClicked();

private slots:
    void on_ezabatuButton_clicked();

private:
    Ui::editInterventionDialog *ui;
    int m_startTime;
    int m_endTime;
    int m_maxTime;
    QString m_type;
    QString m_name;
    bool m_isNew;

    void accept();
};

#endif // EDITINTERVENTIONDIALOG_H
