#include "editinterventiondialog.h"
#include "ui_editinterventiondialog.h"

EditInterventionDialog::EditInterventionDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::editInterventionDialog)
{
    ui->setupUi(this);
    ui->startTimeEdit->setInputMask("99:99:99");
    ui->startTimeEdit->setCursorPosition(0);
    ui->endTimeEdit->setInputMask("99:99:99");

    ui->ezabatuButton->hide();

    QRegExp timeRegExp("^(?:(?:([01]?\\d|2[0-3]):)?([0-5]?\\d):)?([0-5]?\\d)$");
    QValidator *validator = new QRegExpValidator(timeRegExp);
    ui->startTimeEdit->setValidator(validator);
    ui->endTimeEdit->setValidator(validator);

    //connect(this, &QDialog::accepted, this, &EditInterventionDialog::on_accepted);

    setFixedSize(400, 218);
}

EditInterventionDialog::~EditInterventionDialog()
{
    delete ui;
}

void EditInterventionDialog::setType(QString type, QList<Atendee> list, bool isNew)
{
    m_isNew = isNew;
    m_type = type;
    Atendee atendee;
    if(m_isNew){
        this->setWindowTitle(tr("New line"));
    }else{
        this->setWindowTitle(tr("Edit line"));
    }
    ui->typeLabel->setText(tr(m_type.toStdString().c_str()));
    for (int i = 0; i < list.size(); ++i) {
        atendee = list.at(i);
        ui->typeComboBox->addItem(atendee.getName(), "0"); // Ponemos "0" por "compatibilidad" con los Items (estos necesitan su ID)
    }
    if(isNew){
       ui->ezabatuButton->setVisible(false);
    }else{
       //ui->typeComboBox->setDisabled(true);
    }

}
void EditInterventionDialog::setType(QString type, QList<Item> list, bool isNew)
{
    m_isNew = isNew;
    m_type = type;
    Item item;
    ui->typeLabel->setText(tr(m_type.toStdString().c_str()));
    for (int i = 0; i < list.size(); ++i) {
        item = list.at(i);
        ui->typeComboBox->addItem(item.getName(), item.getId());
    }
    if(isNew){
       ui->ezabatuButton->setVisible(false);
    }else{
       //ui->typeComboBox->setDisabled(true);
    }

}

void EditInterventionDialog::setData(int startTime, int endTime, int maxTime, QString name)
{
    m_startTime = startTime;
    m_endTime = endTime;
    m_maxTime = maxTime;
    m_name = name;

    ui->startTimeEdit->setText(QString::number(m_startTime));
    ui->endTimeEdit->setText(QString::number(m_endTime));

    int index = ui->typeComboBox->findText(name);
    if ( index != -1 ) { // -1 for not found
       ui->typeComboBox->setCurrentIndex(index);
    }

}
void EditInterventionDialog::setData(QString startTime, QString endTime, int maxTime, QString name)
{
    Item *item = new Item();
    item->setInitTime(startTime);
    item->setEndTime(endTime);
    m_startTime = item->getInitTimeMillisecs();
    m_endTime = item->getEndTimeMillisecs();
    m_maxTime = maxTime;
    m_name = name;

    ui->startTimeEdit->setText(item->millisecsToTime(m_startTime));
    ui->endTimeEdit->setText(item->millisecsToTime(m_endTime));

    int index = ui->typeComboBox->findText(name);
    if ( index != -1 ) { // -1 for not found
        ui->typeComboBox->setCurrentIndex(index);
    }else{
        // qdebug() << "ez da aurkut" << name;
    }

}

QString EditInterventionDialog::getType()
{
    return m_type;
}

QString EditInterventionDialog::getId()
{
    return (ui->typeComboBox->itemData(ui->typeComboBox->currentIndex()).toString());
}

QString EditInterventionDialog::getName()
{
    return ui->typeComboBox->currentText();
}

qint64 EditInterventionDialog::getStartTime()
{
    QString startTimeText = ui->startTimeEdit->text();
    Item *item = new Item();
    item->setInitTime(startTimeText);

    return item->getInitTimeMillisecs();
}
qint64 EditInterventionDialog::getEndTime()
{
    QString endTimeText = ui->endTimeEdit->text();
    Item *item = new Item();
    item->setEndTime(endTimeText);

    return item->getEndTimeMillisecs();

}

void EditInterventionDialog::on_ezabatuButton_clicked()
{
    QMessageBox msgBox;
    msgBox.setText(tr("You are going to delete a line."));
    msgBox.setInformativeText(tr("Are you sure?"));
    msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
    msgBox.setDefaultButton(QMessageBox::Cancel);
    int ret = msgBox.exec();
    if(ret == QMessageBox::Ok){
        emit deleteClicked();
    }

}

/*void EditInterventionDialog::on_buttonBox_clicked(QAbstractButton *button)
{
    switch (ui->buttonBox->buttonRole(button)){

        case QDialogButtonBox::AcceptRole:
            qDebug() << "acceptrole" << this->getStartTime() << this->getEndTime() << this->m_maxTime;
            //QDialog::accept();
            QDialog::reject();
            break;

        case QDialogButtonBox::RejectRole:
            QDialog::reject();
            break;

    }
}*/

void EditInterventionDialog::accept()
{
    QMessageBox msgBox;
    QString oharra;

    if (this->getStartTime() > this->getEndTime())
        oharra = tr("startTime > endTime");
    else if (this->getStartTime() > this->m_maxTime)
        oharra = tr("startTime > maxTime");
    else if (this->getEndTime() > this->m_maxTime)
        oharra = tr("endTime > maxTime");

    if (!oharra.isEmpty()){

        msgBox.setText(tr("Error"));
        msgBox.setInformativeText(oharra);
        msgBox.setStandardButtons(QMessageBox::Ok);
        msgBox.exec();

    }
    else
        QDialog::accept();
}
