#include "editatendee.h"
#include "ui_editatendee.h"

editAtendee::editAtendee(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::editAtendee)
{
    ui->setupUi(this);

    if (db.isOpen()){
        modeloa = new QSqlRelationalTableModel(ui->zerrenda);
        modeloa->setEditStrategy(QSqlTableModel::OnFieldChange);
        modeloa->setTable("atendee");

        modeloa->setHeaderData(modeloa->fieldIndex("izena"), Qt::Horizontal, tr("Izena"));

        /*proxyModeloa = new QSortFilterProxyModel(ui->zerrenda);
        proxyModeloa->setSourceModel(modeloa);
        proxyModeloa->sort(1, Qt::AscendingOrder);
        proxyModeloa->setSortCaseSensitivity(Qt::CaseInsensitive);*/

        // Populate the model
        if (!modeloa->select()) {
            showError(modeloa->lastError());
            return;
        }

        //ui->zerrenda->setModel(proxyModeloa);
        ui->zerrenda->setModel(modeloa);
        ui->zerrenda->setColumnHidden(modeloa->fieldIndex("id"), true);
        ui->zerrenda->horizontalHeader()->setStretchLastSection(true);
        //ui->zerrenda->setAlternatingRowColors(true);
        ui->zerrenda->setSortingEnabled(true);
        ui->zerrenda->sortByColumn(1, Qt::AscendingOrder);
        ui->zerrenda->installEventFilter(this);
        /*ui->zerrenda->setSelectionMode(QAbstractItemView::SingleSelection);*/

        //connect (modeloa, SIGNAL(dataChanged(const QModelIndex&, const QModelIndex&)), this, SLOT(onDataChanged(const QModelIndex&, const QModelIndex&)));
    }

    setWindowTitle(tr("Edit Atendee"));

    setFixedSize (400, 330);
}

editAtendee::~editAtendee()
{
    delete ui;
}

void editAtendee::on_gehituBotoia_clicked()
{
    QString izena=ui->gehituTestua->text();

    if (db.isOpen() && !izena.isEmpty()){

        QSqlQuery queryAdd;
        queryAdd.prepare("INSERT INTO atendee (izena) VALUES (:izena)");
        queryAdd.bindValue(":izena", izena);

        if(queryAdd.exec())
        {
            ui->gehituTestua->setText("");

            if (!modeloa->select()) {
                showError(modeloa->lastError());
                return;
            }
        }
        else
        {
            // qdebug() << "add atendee failed: " << queryAdd.lastError();
        }

    }

}

void editAtendee::on_gehituTestua_returnPressed()
{
    on_gehituBotoia_clicked();
}

void editAtendee::on_ezabatuBotoia_clicked()
{
    QItemSelection selection(ui->zerrenda->selectionModel()->selection());

    QList<int> rows;
    foreach (const QModelIndex & index, selection.indexes()){
        rows.append (index.row());
    }

    qSort (rows);

    if (rows.count() > 0){
        QMessageBox msgBox;
        msgBox.setWindowTitle(tr("Konfirmazioa"));
        msgBox.setText(tr("Ezabatzea aukeratu duzu. Ziur al zaude?"));
        msgBox.setIcon(QMessageBox::Question);
        msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        msgBox.setDefaultButton(QMessageBox::Cancel);
        int ret = msgBox.exec();

        switch (ret) {
          case QMessageBox::Ok:
            int prev = -1;
            for (int i = rows.count() - 1; i >= 0; i -= 1 ){
                int current = rows[i];
                if (current != prev){
                    modeloa->removeRows(current, 1);
                    prev = current;
                }
            }

            if (rows.count() > 0){

                if (!modeloa->select()) {
                    showError(modeloa->lastError());
                    return;
                }
            }

            break;
        }
    }
}

void editAtendee::onDataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
{
    modeloa->submitAll();

    if (!modeloa->select()) {
        showError(modeloa->lastError());
        return;
    }
}

bool editAtendee::eventFilter(QObject *object, QEvent *event)
{
    if (object == ui->zerrenda) {

        if (event->type() == QEvent::KeyPress) {

            QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            switch(keyEvent->key()) {
                case Qt::Key_Delete:
                    on_ezabatuBotoia_clicked();
                    break;
                case Qt::Key_Escape:
                    close();
                break;
            }

            return true;

        }
        else {
            return false;
        }

    }
    else {
        return QWidget::eventFilter(object, event);
    }
}

void editAtendee::keyPressEvent(QKeyEvent *keyEvent)
{
    if (keyEvent->key() == Qt::Key_Escape)
        close();
}

void editAtendee::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}
