#ifndef DBMANAGER_H
#define DBMANAGER_H

#include <QSqlDatabase>
#include <QCoreApplication>
#include <QDebug>
#include <QtSql>

/**
 * \class DbManager
 *
 * \brief SQL Database Manager class
 *
 * DbManager sets up the connection with SQL database.
 * The class requires existing SQL database. You can create it with sqlite:
 * 1. $ sqlite3 datubasea.db
 * 2. sqilte> CREATE TABLE atendee(id integer primary key, izena text);
 *    sqlite> CREATE TABLE theme(id integer primary key, izena text);
 *    sqlite> CREATE TABLE record(id integer primary key, data text, izena text, deskribapena text, folderPath text, fileName text, audioVideo integer, atendees text, themes text);
 *    sqlite> .quit
 */
class DbManager
{
public:
    /**
     * @brief Constructor
     *
     */
    DbManager();

    /**
     * @brief Destructor
     *
     */
    ~DbManager();

    void closeConnection ();

    bool isOpen();

    void checkDatabase ();

    bool open();

private:
    QSqlDatabase mydb;

    QString getDBFolderPath() ;
    bool tableExists (QString table);
    bool tableColumnExists (QString table, QString column);
};

#endif // DBMANAGER_H
