#include <dbmanager.h>

DbManager::DbManager()
{
    this->mydb = QSqlDatabase::database();
}

bool DbManager::open()
{
    if (!this->mydb.isValid())
    {
        this->mydb = QSqlDatabase::addDatabase("QSQLITE");
        this->mydb.setDatabaseName(this->getDBFolderPath() + "/datubasea.db");

        return this->mydb.open();
    }

    return false;
}

DbManager::~DbManager()
{
    //closeConnection();
}

QString DbManager::getDBFolderPath()
{
    QString path = QDir::homePath() + "/.akta-gardena";

    if (QDir(path).exists()){
        QFileInfo my_dir(path);

        if(my_dir.isWritable())
            return (path);
        else
            return (QDir::homePath());
    }
    else{
        if (QDir().mkdir (path))
            return (path);
        else
            return (QDir::homePath());
    }
}

void DbManager::closeConnection()
{
    if (this->mydb.isOpen())
    {
        QString connection = this->mydb.connectionName();

        this->mydb.close();

        //this->mydb.removeDatabase(connection);
    }
}

bool DbManager::isOpen()
{
    if (this->mydb.isOpen()){
        return true;
    }
    else{
        return this->open();
    }
}

void DbManager::checkDatabase ()
{
    QSqlQuery query;

    /** TAULAK **/

    query.prepare("CREATE TABLE IF NOT EXISTS atendee(id integer primary key autoincrement, izena text)");
    query.exec();

    query.prepare("CREATE TABLE IF NOT EXISTS record(id integer primary key autoincrement, data text, izena text, mota text, deskribapena text, folderPath text, fileName text, audioVideo integer, atendees text, themes text, egoera text, files text, erabakiakFile text, session_type_id integer, izena_es text)");
    query.exec();

    query.prepare("CREATE TABLE IF NOT EXISTS record_notes(id integer primary key autoincrement, noiz text, testua text, record_id integer)");
    query.exec();

    query.prepare("CREATE TABLE IF NOT EXISTS rol(id integer primary key autoincrement, izena text)");
    query.exec();

    query.prepare("CREATE TABLE IF NOT EXISTS session_type(id integer primary key autoincrement, izena text, izena_es text)");
    query.exec();

    query.prepare("CREATE TABLE IF NOT EXISTS theme(id integer primary key autoincrement, izena text, izena_es text)");
    query.exec();

    /** EREMUAK **/

    if (!this->tableColumnExists ("record", "egoera"))
    {
        query.prepare("ALTER TABLE record ADD COLUMN egoera text");
        query.exec();

        query.prepare("UPDATE record SET egoera='verify'");
        query.exec();
    }

    if (!this->tableColumnExists ("record", "files"))
    {
        query.prepare("ALTER TABLE record ADD COLUMN files text");
        query.exec();

        query.prepare("UPDATE record SET files=''");
        query.exec();
    }

    if (!this->tableColumnExists ("record", "erabakiakFile"))
    {
        query.prepare("ALTER TABLE record ADD COLUMN erabakiakFile text");
        query.exec();

        query.prepare("UPDATE record SET erabakiakFile=''");
        query.exec();
    }

    if (!this->tableColumnExists ("session_type", "izena_es"))
    {
        query.prepare("ALTER TABLE session_type ADD COLUMN izena_es text");
        query.exec();
    }

    if (!this->tableColumnExists ("record", "session_type_id"))
    {
        query.prepare("ALTER TABLE record ADD COLUMN session_type_id integer");
        query.exec();

        query.prepare("UPDATE record SET session_type_id=0");
        query.exec();
    }

    if (!this->tableColumnExists ("record", "izena_es"))
    {
        query.prepare("ALTER TABLE record ADD COLUMN izena_es text");
        query.exec();

        query.prepare("UPDATE record SET izena_es=izena");
        query.exec();
    }

    if (!this->tableColumnExists ("theme", "izena_es"))
    {
        query.prepare("ALTER TABLE theme ADD COLUMN izena_es text");
        query.exec();

        query.prepare("UPDATE theme SET izena_es=izena");
        query.exec();
    }

    /** EDUKIA **/

    query.prepare("DELETE FROM session_type");
    query.exec();

    query.prepare("INSERT INTO session_type (id, izena, izena_es) VALUES (1, 'Ohiko osoko bilkura', 'Plenos ordinarios municipales')");
    query.exec();
    query.prepare("INSERT INTO session_type (id, izena, izena_es) VALUES (2, 'Aparteko osoko bilkura', 'Plenos extraordinarios municipales')");
    query.exec();
    query.prepare("INSERT INTO session_type (id, izena, izena_es) VALUES (3, 'Barne batzordea', 'Comisión interna')");
    query.exec();
    query.prepare("INSERT INTO session_type (id, izena, izena_es) VALUES (4, 'Gobernu batzarra', 'Junta de Gobierno')");
    query.exec();
    query.prepare("INSERT INTO session_type (id, izena, izena_es) VALUES (5, 'Bozeramaile batzarra', 'Junta de portavoces')");
    query.exec();
    query.prepare("INSERT INTO session_type (id, izena, izena_es) VALUES (2001, 'Besterik', 'Otros')");
    query.exec();
}

bool DbManager::tableExists (QString table)
{
    if (this->mydb.isOpen())
    {
        QSqlQuery query;

        query.prepare("PRAGMA table_info(" + table + ")");
        query.exec();

        query.first();
        return (query.isValid());
    }

    return (false);
}

bool DbManager::tableColumnExists (QString table, QString column)
{
    if (this->mydb.isOpen())
    {
        QSqlQuery query;

        query.prepare("PRAGMA table_info(" + table + ")");
        query.exec();

        query.first();
        if (query.isValid())
        {
            do{
                if (query.value("name").toString().compare(column) == 0)
                    return (true);
            }while(query.next());
        }
    }

    return (false);
}
