#ifndef CONFIGURATOR_H
#define CONFIGURATOR_H

#include <QWidget>
#include <QObject>
#include <QString>
#include <QtSql>
#include <QDesktopWidget>
#include <QMessageBox>
#include "QGstStream.h"

#include "ui_configurator.h"
#include "selectatendee.h"
#include "selecttheme.h"
#include "steps.h"
#include "dbmanager.h"
#include "funtzioak.h"

namespace Ui {
class Configurator;
}

class Configurator : public QWidget
{
    Q_OBJECT

public:
    explicit Configurator(QWidget *parent = 0);
    ~Configurator();

    void sessionTypeReload();
    void datuakKargatu (int record_id);


private slots:

    void on_startRecordingButton_clicked();

    void on_selectAtendeesBotoia_clicked();
    void on_selectThemesBotoia_clicked();

    void on_atendeesKargatu(QList<QString> zerrenda);
    void on_themesKargatu(QList<QString> zerrenda);

    void on_selectFilesButton_clicked();

    void on_gordeButton_clicked();

protected:
    bool eventFilter(QObject *obj, QEvent *ev);

private:
    Ui::configurationScreen config_ui;

    QPoint erdianKokatu (int zabalera, int altuera);
    void oharra(QString mezua);
    void sessionTypeSelect(int session_type_id, QString value);

    QStringList currentAtendees;
    QStringList currentItems;
    QStringList currentFiles;
    QString folderPath;
    //QList<QFile*> additionalFiles;
    selectAtendee *selectAtendeeWidget;
    selectTheme *selectThemeWidget;

    QSqlRelationalTableModel *sessionTypeModeloa;

    DbManager db;

    int recordId;

    void datuakGordeDB();
    void getFolderPath();
    void showError(const QSqlError &err);

signals:
    void recorderSetCentralWidget(int record_id);

};

#endif // CONFIGURATOR_H
