#include "configurator.h"
#include <QDebug>
#include <QFileDialog>
#include <QMessageBox>
#include <QString>
#include <QCheckBox>
#include <QFormLayout>

//Init main configuration window
/**
 * @brief Configurator::Configurator The constructor
 * @param parent
 */
Configurator::Configurator(QWidget *parent) : QWidget(parent)
{
    config_ui.setupUi(this);
    config_ui.stepsLayout->addLayout(Steps::getSteps(1));

    config_ui.zerrendaAtendee->installEventFilter(this);
    config_ui.zerrendaTheme->installEventFilter(this);
    config_ui.zerrendaFile->installEventFilter(this);

    config_ui.selectThemesBotoia->setStyleSheet("border: none;");
    config_ui.selectThemesBotoia->setCursor(Qt::PointingHandCursor);

    config_ui.selectAtendeesBotoia->setStyleSheet("border: none;");
    config_ui.selectAtendeesBotoia->setCursor(Qt::PointingHandCursor);

    config_ui.sessionLabel->setText(config_ui.sessionLabel->text() + " (eu)");
    config_ui.sessionEsLabel->setText(config_ui.sessionEsLabel->text() + " (es)");

    ///Initialize to home folder if no folder is selected
    this->getFolderPath();

    if (db.isOpen()){
        sessionTypeModeloa = new QSqlRelationalTableModel(config_ui.sessionTypeCombo);
        sessionTypeModeloa->setTable("session_type");
        sessionTypeModeloa->setSort(sessionTypeModeloa->fieldIndex("id"), Qt::AscendingOrder);

        // Populate the model
        if (!sessionTypeModeloa->select()) {
            showError(sessionTypeModeloa->lastError());
            return;
        }

        config_ui.sessionTypeCombo->setModel(sessionTypeModeloa);

        if (QLocale().name().toStdString().compare("es_ES") == 0){
            config_ui.sessionTypeCombo->setModelColumn(sessionTypeModeloa->fieldIndex("izena_es"));
        }
        else{
            config_ui.sessionTypeCombo->setModelColumn(sessionTypeModeloa->fieldIndex("izena"));
        }
    }

    this->currentAtendees.clear();
    this->currentItems.clear();
    this->currentFiles.clear();
    this->recordId = 0;
}

/**
 * @brief Configurator::~Configurator Destructor
 */
Configurator::~Configurator()
{
}

/**
 * @brief Configurator::on_startRecordingButton_clicked This slot will launch recording interface when actioned.
 * It is connected to clicked signal from Start Recording button from main configuration window
 * It will launch the recording screen and pass appropriate parameters to it
 */
void Configurator::on_startRecordingButton_clicked()
{
    /*QString sessionName=config_ui.sessionNameInput->text();
    QString shortDescription=config_ui.shortDescriptionInput->toPlainText();
    QString sessionType = config_ui.sessionTypeCombo->itemText(config_ui.sessionTypeCombo->currentIndex());*/

    if (config_ui.sessionNameInput->text().length() == 0 && config_ui.sessionNameEsInput->text().length() == 0){
        oharra(tr("Session Name eremua bete behar da."));
        config_ui.sessionNameInput->setFocus();
        return;
    }

    if (config_ui.zerrendaTheme->count() == 0){
        oharra(tr("Theme-ren bat aukeratu behar da."));
        return;
    }

    if (config_ui.zerrendaAtendee->count() == 0){
        oharra(tr("Atendee-ren bat aukeratu behar da."));
        return;
    }

    this->datuakGordeDB();

    /*Recorder *recordWidget= new Recorder(this->folderPath,currentAtendees,currentItems,sessionName,shortDescription);
    recordWidget->setAttribute( Qt::WA_DeleteOnClose );
    recordWidget->show();*/

    emit recorderSetCentralWidget(this->recordId);
}

void Configurator::on_selectAtendeesBotoia_clicked()
{
    selectAtendeeWidget = new selectAtendee();
    selectAtendeeWidget->setAttribute(Qt::WA_DeleteOnClose);
    selectAtendeeWidget->setWindowModality(Qt::ApplicationModal);

    // Centramos la ventana
    selectAtendeeWidget->move(erdianKokatu(selectAtendeeWidget->width(), selectAtendeeWidget->height()));

    // Mostramos la ventana
    selectAtendeeWidget->show();

    connect(selectAtendeeWidget, SIGNAL(atendeesKargatu(QList<QString>)), this, SLOT(on_atendeesKargatu(QList<QString>)));
}

void Configurator::on_selectThemesBotoia_clicked()
{
    selectThemeWidget = new selectTheme();
    selectThemeWidget->setAttribute(Qt::WA_DeleteOnClose);
    selectThemeWidget->setWindowModality(Qt::ApplicationModal);

    // Centramos la ventana
    selectThemeWidget->move(erdianKokatu(selectThemeWidget->width(), selectThemeWidget->height()));

    // Mostramos la ventana
    selectThemeWidget->show();

    connect(selectThemeWidget, SIGNAL(themesKargatu(QList<QString>)), this, SLOT(on_themesKargatu(QList<QString>)));
}

void Configurator::on_atendeesKargatu(QList<QString> zerrenda)
{
    QList<QListWidgetItem *> findItems;

    for (int i = 0; i < zerrenda.size(); ++i)
    {
        findItems = config_ui.zerrendaAtendee->findItems(zerrenda.at(i), Qt::MatchExactly);
        if (findItems.size() == 0)
            config_ui.zerrendaAtendee->addItem(zerrenda.at(i));
    }

    config_ui.zerrendaAtendee->sortItems(Qt::AscendingOrder);
}

void Configurator::on_themesKargatu(QList<QString> zerrenda)
{
    QList<QListWidgetItem *> findItems;

    for (int i = 0; i < zerrenda.size(); ++i)
    {
        QString id = Funtzioak::getTxurroThemeId(zerrenda.at(i));
        QString tema = Funtzioak::getTxurroThemeIzena(zerrenda.at(i));

        findItems = config_ui.zerrendaTheme->findItems(tema, Qt::MatchExactly);
        if (findItems.size() == 0){
            QListWidgetItem* item = new QListWidgetItem(tema, config_ui.zerrendaTheme);

            QVariant idV;
            idV.setValue(id);
            item->setData(Qt::UserRole, idV);
        }
    }

    config_ui.zerrendaTheme->sortItems(Qt::AscendingOrder);
}

bool Configurator::eventFilter(QObject *object, QEvent *event)
{
    if (object == config_ui.zerrendaAtendee || object == config_ui.zerrendaTheme || object == config_ui.zerrendaFile) {
        QListWidget *zerrenda = qobject_cast<QListWidget *>(object);

        if (event->type() == QEvent::KeyPress) {

            QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            switch(keyEvent->key()) {
                case Qt::Key_Delete:
                    qDeleteAll(zerrenda->selectedItems());
                    break;
            }

            return true;

        }
        else {
            return false;
        }

    }
    else {
        return QWidget::eventFilter(object, event);
    }
}

QPoint Configurator::erdianKokatu (int zabalera, int altuera){
    QPoint puntu;

    /* Pantailaren erdian kokatzeko */
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    puntu.setX((screenGeometry.width() - zabalera) / 2);
    puntu.setY((screenGeometry.height() - altuera) / 2);

    return (puntu);
}

void Configurator::oharra(QString mezua)
{
    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("Oharra"));
    msgBox.setText(mezua);
    msgBox.setIcon(QMessageBox::Warning);
    msgBox.setStandardButtons(QMessageBox::Ok);
    msgBox.exec();
}

void Configurator::on_selectFilesButton_clicked()
{
    QStringList fileNames = QFileDialog::getOpenFileNames(this, tr("Select files") );
    QList<QListWidgetItem *> findItems;
    for(int i = 0; i < fileNames.count(); ++i){
        /*QFile *file = new QFile(fileNames.at(i));*/
        findItems = config_ui.zerrendaFile->findItems(fileNames.at(i), Qt::MatchExactly);
        if(findItems.size() == 0){
            /*this->additionalFiles.append(file);*/
            config_ui.zerrendaFile->addItem(fileNames.at(i));
        }

    }

}

void Configurator::showError(const QSqlError &err)
{
    QMessageBox::critical(this, tr("Errorea"), tr("errorearen deskribapena: ") + err.text());
}

void Configurator::sessionTypeReload()
{
    QString sessionType = config_ui.sessionTypeCombo->itemText(config_ui.sessionTypeCombo->currentIndex());
    int session_type_id = sessionTypeModeloa->data(sessionTypeModeloa->index(config_ui.sessionTypeCombo->currentIndex(), sessionTypeModeloa->fieldIndex("id"))).toInt();
    // qdebug() << "sessiontype" << sessionType;

    // Populate the model
    if (!sessionTypeModeloa->select()) {
        showError(sessionTypeModeloa->lastError());
        return;
    }

    // Mantenemos la selección
    this->sessionTypeSelect(session_type_id, sessionType);
}

void Configurator::on_gordeButton_clicked()
{
    QMessageBox msgBox;

    this->datuakGordeDB();

    msgBox.setText(tr("The changes have been saved"));
    msgBox.setStandardButtons(QMessageBox::Ok);
    msgBox.setDefaultButton(QMessageBox::Ok);
    msgBox.exec();
}

void Configurator::datuakGordeDB()
{
    QSqlQuery query;

    QString izena = !config_ui.sessionNameInput->text().isEmpty() ? config_ui.sessionNameInput->text() : config_ui.sessionNameEsInput->text();
    QString izena_es = !config_ui.sessionNameEsInput->text().isEmpty() ? config_ui.sessionNameEsInput->text() : config_ui.sessionNameInput->text();

    this->currentAtendees.clear();
    this->currentItems.clear();
    this->currentFiles.clear();

    for (int i = 0; i < config_ui.zerrendaAtendee->count(); i++)
        this->currentAtendees.append(config_ui.zerrendaAtendee->item(i)->text());

    for (int i = 0; i < config_ui.zerrendaTheme->count(); i++){
        QVariant id = config_ui.zerrendaTheme->item(i)->data(Qt::UserRole);

        this->currentItems.append(id.toString() + "##_##" + config_ui.zerrendaTheme->item(i)->text());
    }

    for (int i = 0; i < config_ui.zerrendaFile->count(); i++)
        this->currentFiles.append(config_ui.zerrendaFile->item(i)->text());

    this->getFolderPath();

    if (db.isOpen()){

        if (this->recordId == 0){
            query.prepare("INSERT INTO record (data, izena, mota, deskribapena, folderPath, fileName, audioVideo, atendees, themes, files, egoera, session_type_id, izena_es) "
                          "VALUES (:data, :izena, :mota, :deskribapena, :folderPath, '', 0, :atendees, :themes, :files, 'config', :session_type_id, :izena_es)");
            query.bindValue(":data", QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss"));
            query.bindValue(":izena", izena);
            query.bindValue(":mota", config_ui.sessionTypeCombo->itemText(config_ui.sessionTypeCombo->currentIndex()));
            query.bindValue(":deskribapena", config_ui.shortDescriptionInput->toPlainText());
            query.bindValue(":folderPath", this->folderPath);
            query.bindValue(":atendees", this->currentAtendees.join("@@_@@"));
            query.bindValue(":themes", this->currentItems.join("@@_@@"));
            query.bindValue(":files", this->currentFiles.join("@@_@@"));
            query.bindValue(":session_type_id", sessionTypeModeloa->data(sessionTypeModeloa->index(config_ui.sessionTypeCombo->currentIndex(), sessionTypeModeloa->fieldIndex("id"))).toInt());
            query.bindValue(":izena_es", izena_es);
            query.exec();

            this->recordId = query.lastInsertId().toInt();
        }
        else{
            query.prepare("UPDATE record SET data=:data, izena=:izena, mota=:mota, deskribapena=:deskribapena, folderPath=:folderPath, atendees=:atendees, themes=:themes, files=:files, session_type_id=:session_type_id, izena_es=:izena_es WHERE id=:recordId");
            query.bindValue(":data", QDateTime::currentDateTime().toString("yyyy/MM/dd HH:mm:ss"));
            query.bindValue(":izena", izena);
            query.bindValue(":mota", config_ui.sessionTypeCombo->itemText(config_ui.sessionTypeCombo->currentIndex()));
            query.bindValue(":deskribapena", config_ui.shortDescriptionInput->toPlainText());
            query.bindValue(":folderPath", this->folderPath);
            query.bindValue(":atendees", this->currentAtendees.join("@@_@@"));
            query.bindValue(":themes", this->currentItems.join("@@_@@"));
            query.bindValue(":files", this->currentFiles.join("@@_@@"));
            query.bindValue(":session_type_id", sessionTypeModeloa->data(sessionTypeModeloa->index(config_ui.sessionTypeCombo->currentIndex(), sessionTypeModeloa->fieldIndex("id"))).toInt());
            query.bindValue(":izena_es", izena_es);
            query.bindValue(":recordId", this->recordId);
            query.exec();
        }

    }
}

void Configurator::datuakKargatu (int record_id)
{
    QSqlQuery query;

    if (db.isOpen()){

        query.prepare("SELECT * FROM record WHERE id=:recordId");
        query.bindValue(":recordId", record_id);
        query.exec();

        query.first();
        if (query.isValid()){
            this->recordId = record_id;

            config_ui.sessionNameInput->setText(query.value("izena").toString());
            config_ui.sessionNameEsInput->setText(query.value("izena_es").toString());
            config_ui.shortDescriptionInput->document()->setPlainText(query.value("deskribapena").toString());
            this->sessionTypeSelect(query.value("session_type_id").toInt(), query.value("mota").toString());

            /* DIREKTORIOA */
            if (QDir(query.value("folderPath").toString()).exists()){
                QFileInfo my_dir(query.value("folderPath").toString());

                if(my_dir.isWritable())
                    this->folderPath=query.value("folderPath").toString();
                else
                    this->folderPath=QDir::homePath();
            }
            else
                this->folderPath=QDir::homePath();

            /* PARTE HARTZAILEAK */
            config_ui.zerrendaAtendee->clear();

            QStringListIterator atendeesItr(query.value("atendees").toString().split("@@_@@"));
            while (atendeesItr.hasNext()){
                QString elem = atendeesItr.next();

                if (elem != "")
                    config_ui.zerrendaAtendee->addItem(elem);
            }

            /* GAIAK */
            config_ui.zerrendaTheme->clear();

            QStringListIterator themesItr(query.value("themes").toString().split("@@_@@"));
            while (themesItr.hasNext()){
                QString elem = themesItr.next();
                QString id = Funtzioak::getTxurroThemeId(elem);
                QString tema = Funtzioak::getTxurroThemeIzena(elem, true);

                if (tema != ""){
                    QListWidgetItem* item = new QListWidgetItem(tema, config_ui.zerrendaTheme);

                    QVariant idV;
                    idV.setValue(id);
                    item->setData(Qt::UserRole, idV);
                }
            }

            config_ui.zerrendaTheme->sortItems(Qt::AscendingOrder);

            /* FITXATEGIAK */
            config_ui.zerrendaFile->clear();

            QStringListIterator filesItr(query.value("files").toString().split("@@_@@"));
            while (filesItr.hasNext()){
                QString elem = filesItr.next();
                QFileInfo txek(elem);

                if (txek.exists() && txek.isFile())
                    config_ui.zerrendaFile->addItem(elem);
            }
        }
    }
}

void Configurator::sessionTypeSelect(int session_type_id, QString value)
{
    // ID-a bilatu
    for (int i=0; i < sessionTypeModeloa->rowCount(); i++){
        if (sessionTypeModeloa->data(sessionTypeModeloa->index(i, sessionTypeModeloa->fieldIndex("id"))).toInt() == session_type_id){
            config_ui.sessionTypeCombo->setCurrentIndex(i);
            return;
        }
    }

    // value-a bilatu (por retrocompatibilidad absurda)
    for (int i=0; i < sessionTypeModeloa->rowCount(); i++){
        if (config_ui.sessionTypeCombo->itemText(i) == value){
            config_ui.sessionTypeCombo->setCurrentIndex(i);
            return;
        }
    }

    // Seleccionamos el primer elemento (no se ha encontrado "value")
    config_ui.sessionTypeCombo->setCurrentIndex(0);
}

void Configurator::getFolderPath()
{
    QSettings settings("bideoakta", "iametza");

    if (!settings.contains("data_folder")){
        settings.setValue("data_folder", QDir::homePath());
        this->folderPath = QDir::homePath();
    }
    else{
        if (QDir(settings.value("data_folder").toString()).exists()){
            QFileInfo my_dir(settings.value("data_folder").toString());

            if(my_dir.isWritable())
                this->folderPath = settings.value("data_folder").toString();
            else{
                settings.setValue("data_folder", QDir::homePath());
                this->folderPath = QDir::homePath();
            }
        }
        else{
            settings.setValue("data_folder", QDir::homePath());
            this->folderPath = QDir::homePath();
        }
    }
}
