# This is a qmake project file, provided as an example on how to use qmake with QtGStreamer.
QT += widgets core gui xml multimedia multimediawidgets webenginewidgets network sql

TEMPLATE = app
TARGET = "Akta gardena"

# produce nice compilation output
CONFIG += silent

# Now tell qmake to link to QtGStreamer and also use its include path and Cflags.
#contains(QT_VERSION, ^4\\..*) {
  #PKGCONFIG += QtGStreamer-1.0 Qt5GStreamerUi-1.0
#}
#contains(QT_VERSION, ^5\\..*) {
  #PKGCONFIG += Qt5GStreamer-1.0 Qt5GStreamerUi-1.0
#  QT += widgets core gui xml multimedia multimediawidgets network
#}

# Input
FORMS += configurator.ui \
    recorder.ui \
    editatendee.ui \
    edittheme.ui \
    selectatendee.ui \
    selecttheme.ui \
    settingsaudio.ui \
    settingsvideo.ui \
    login.ui \
    firstscreen.ui \
    selectrecord.ui \
    editinterventiondialog.ui \
    signform.ui \
    foldersettings.ui \
    editsessiontype.ui \
    editnotedialog.ui \
    editrol.ui \
    lanean.ui \
    publikatu.ui

SOURCES += atendee.cpp \
    configurator.cpp \
    dbmanager.cpp \
    editatendee.cpp \
    edittheme.cpp \
    firstscreen.cpp \
    item.cpp \
    log.cpp \
    login.cpp \
    main.cpp \
    mainwindow.cpp \
    mediaapp.cpp \
    QGstStream.cpp \
    recorder.cpp \
    selectatendee.cpp \
    selecttheme.cpp \
    settingsaudio.cpp \
    settingsvideo.cpp \
    videoplayer.cpp \
    selectrecord.cpp \
    interventionitem.cpp \
    interventionmodel.cpp \
    listitemdelegate.cpp \
    steps.cpp \
    editinterventiondialog.cpp \
    signform.cpp \
    foldersettings.cpp \
    editsessiontype.cpp \
    editnotedialog.cpp \
    editrol.cpp \
    izfesinadura.cpp \
    nabigatzailea.cpp \
    customurlschemehandler.cpp \
    lanean.cpp \
    publikatu.cpp \
    funtzioak.cpp \
    simplecrypt.cpp


HEADERS += atendee.h \
    configurator.h \
    dbmanager.h \
    editatendee.h \
    edittheme.h \
    firstscreen.h \
    item.h \
    log.h \
    login.h \
    mainwindow.h \
    mediaapp.h \
    QGstStream.h \
    recorder.h \
    selectatendee.h \
    selecttheme.h \
    settingsaudio.h \
    settingsvideo.h \
    videoplayer.h \
    selectrecord.h \
    interventionitem.h \
    interventionmodel.h \
    listitemdelegate.h \
    steps.h \
    editinterventiondialog.h \
    signform.h \
    foldersettings.h \
    editsessiontype.h \
    editnotedialog.h \
    editrol.h \
    izfesinadura.h \
    nabigatzailea.h \
    customurlschemehandler.h \
    lanean.h \
    publikatu.h \
    simplecrypt.h

TRANSLATIONS = languages/bideoakta_eu.ts  languages/bideoakta_es.ts languages/qtbase_eu.ts languages/qtbase_es.ts

OTHER_FILES = languages/bideoakta_eu.qm

win32{

    contains(QT_ARCH, i386) {
        message("Windows 32-Bit build")
        INCLUDEPATH += D:\gstreamer\1.0\x86\lib\gstreamer-1.0\include \
            D:\gstreamer\1.0\x86\include\gstreamer-1.0 \
            D:\gstreamer\1.0\x86\include\glib-2.0 \
            D:\gstreamer\1.0\x86\lib\glib-2.0\include \
            C:\Qt\5.14.2\5.14.2\msvc2017\bin
        LIBS += -LD:\gstreamer\1.0\x86\lib\ -lgstreamer-1.0 \
            -lglib-2.0 \
            -lgobject-2.0 \
            -lgstapp-1.0 \
            -lgstpbutils-1.0 \
            C:\Qt\5.14.2\5.14.2\msvc2017\lib\Qt5Ftp.lib
    } else {
        message("Windows 64-Bit build")
        INCLUDEPATH += D:\gstreamer\1.0\x86_64\lib\gstreamer-1.0\include \
            D:\gstreamer\1.0\x86_64\include\gstreamer-1.0 \
            D:\gstreamer\1.0\x86_64\include\glib-2.0 \
            D:\gstreamer\1.0\x86_64\lib\glib-2.0\include \
            C:\Qt\5.14.2\5.14.2\msvc2017_64\bin
        LIBS += -LD:\gstreamer\1.0\x86_64\lib\ -lgstreamer-1.0 \
            -lglib-2.0 \
            -lgobject-2.0 \
            -lgstapp-1.0 \
            -lgstpbutils-1.0 \
            C:\Qt\5.14.2\5.14.2\msvc2017_64\lib\Qt5Ftp.lib
    }

}
unix:!macx{
    message("Unix build")

    # Tell qmake to use pkg-config to find QtGStreamer.
    CONFIG += link_pkgconfig
    PKGCONFIG += gstreamer-1.0 glib-2.0 gobject-2.0 gstreamer-app-1.0 gstreamer-pbutils-1.0

    #Qt5Ftp
    #LIBS += -lQt5Ftp
    #PKGCONFIG += Qt5Ftp
    INCLUDEPATH += /usr/include/x86_64-linux-gnu/qt5/QtFtp
    LIBS += /usr/lib/x86_64-linux-gnu/libQt5Ftp.a
}
macx{
    message("Mac build")
    ICON = images/ikonoMacOS.icns

    #INCLUDEPATH += /Library/Frameworks/GStreamer.framework/Versions/1.0/lib/gstreamer-1.0/include \
    #    /Library/Frameworks/GStreamer.framework/Versions/1.0/include/gstreamer-1.0 \
    #    /Library/Frameworks/GStreamer.framework/Versions/1.0/include/glib-2.0 \
    #    /Library/Frameworks/GStreamer.framework/Versions/1.0/lib/glib-2.0/include \
    #    /Users/elisabethpombo/Qt/5.11.1/clang_64/bin

    #LIBS += -L/Library/Frameworks/GStreamer.framework/Versions/1.0/lib -lgstreamer-1.0 \
    #        -lglib-2.0 \
    #        -lgobject-2.0 \
    #        -lgstapp-1.0 \
    #        -lgstpbutils-1.0
}

DISTFILES += \
    languages/bideoakta_es.ts \
    languages/bideoakta_eu.ts \
    languages/bideoakta_eu.qm \
    languages/bideoakta_es.qm \
    bideoakta.rc

RESOURCES += \
    resources.qrc

RC_FILE = bideoakta.rc
