#include "atendee.h"
/*
 * This class contains a definition of an atendee to a meeting, it will contain his/her name and the beginining and ending time of his speech
 *
 * */


/**
 * @brief Atendee::Atendee Constructor
 */
Atendee::Atendee()
{
    return;
}
/**
 * @brief Atendee::~Atendee Destructor
 */
Atendee::~Atendee()
{
}

/**
 * @brief Atendee::setName set name of the atendee to the meeting
 * @param name
 */
void Atendee::setName(QString name)
{
    this->name=name;
}

/**
 * @brief Atendee::getName get the name of the atendee to the meeting
 * @return
 */
QString Atendee::getName()
{
    return this->name;
}

/**
 * @brief Atendee::setInitTime set initial time of the atendee's speech
 * @param initTime QString containing time in hh:mm:ss format (leading zeros)
 */
void Atendee::setInitTime(QString initTime)
{
    this->initTime=initTime;
    int millisecs=0;
    if(initTime!="NaN")
    {
        millisecs=timeToMillisecs(initTime);
    }
    setInitTimeMillisecs(millisecs);
}

/**
 * @brief Atendee::getInitTime get initial time of the speech of the atendee
 * @return It will return a QString containing initial time in hh:mm:ss format (leading zeros)
 */
QString Atendee::getInitTime()
{
    return this->initTime;
}

/**
 * @brief Atendee::setEndTime set initial time of the atendee's speech
 * @param endTime QString containing time in hh:mm:ss format (leading zeros)
 */
void Atendee::setEndTime(QString endTime)
{
    this->endTime=endTime;
    int millisecs=0;
    if(endTime!="NaN")
    {
        millisecs=timeToMillisecs(endTime);
    }
    setEndTimeMillisecs(millisecs);
}

/**
 * @brief Atendee::getEndTime get ending time of the speech of the atendee
 * @returnIt will return a QString containing ending time in hh:mm:ss format (leading zeros)
 */
QString Atendee::getEndTime()
{
    return this->endTime;
}

/**
 * @brief Atendee::setInitTimeMillisecs set init time in millisecs
 * @param millisecs a int containing the millisecs
 */

void Atendee::setInitTimeMillisecs(int millisecs)
{
    this->initTimeMillisecs=millisecs;
}

/**
 * @brief Atendee::getInitTimeMillisecs This method will return Init time in millisecs
 * @return an int containing millisecs
 */
int Atendee::getInitTimeMillisecs()
{
    return this->initTimeMillisecs;
}

/**
 * @brief Atendee::setEndTimeMillisecs This method will set EndTime of the speech of the atendee in millisecs
 * @param millisecs
 */
void Atendee::setEndTimeMillisecs(int millisecs)
{
    this->endTimeMillisecs=millisecs;
}

/**
 * @brief Atendee::getEndTimeMillisecs This method will
 * @return an int containing millisecs
 */
int Atendee::getEndTimeMillisecs()
{
    return this->endTimeMillisecs;
}

/**
 * @brief Atendee::timeToMillisecs this method will transform time in millisecs
 * @param time QString containing time given in hh:mm:ss format
 * @return an int containing millisecs
 */
int Atendee::timeToMillisecs(QString time)
{
    QTime currentTime=QTime::fromString(time,"hh:mm:ss");
    int hour=currentTime.hour();
    int minute=currentTime.minute();
    int second=currentTime.second();
    int millisecs=(hour*3600+minute*60+second)*1000;
    return millisecs;
}
