/**
* @author     iametza interaktiboa
* @date       July 6, 2017
* @version    1.1.0
*/

#ifndef QGSTSTREAM_H
#define QGSTSTREAM_H

#include <gst/app/gstappsink.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <QWidget>
#include <QDir>
#include <QApplication>
#include <QDialog>
#include <QMessageBox>
#include <QString>

//#include <OpenThreads/Thread>


class QGstStream : public QWidget{

public:

    QGstStream();
    ~QGstStream();

	bool start();


	virtual void play();
	virtual void pause();
	virtual void stop();

    virtual void rewind();
    virtual void seek(double time);
    virtual bool isEndOfStream() const;

    int getCurrentMillisecs();

/*
	virtual int s() const;
    virtual int t() const;*/

    void setType(int type);
    void setPath(QString path);
    void setMode(int mode);
    void setConnection(int connection);

    gdouble get_dB ();

private:

    static gboolean on_message(GstBus *bus, GstMessage *message, QGstStream *user_data);

    static GstFlowReturn on_new_sample(GstAppSink *appsink, QGstStream *user_data);
    static GstFlowReturn on_new_preroll(GstAppSink *appsink, QGstStream *user_data);
    static bool message_handler (GstBus * bus, GstMessage * message, gpointer data);
    void set_dB (gdouble dB);

	virtual void run();

	GMainLoop *loop;
	GstElement *pipeline;

	unsigned char *internal_buffer;

	int width;
	int height;
    int type;//0=audio,1=video
    QString path;
    int connection;
    int mode;

    gdouble dB;
};

#endif // QGSTSTREAM_H
