# Arquitectura

## Clases
La aplicación consta de 9 clases

* Configurator
* Atendee
* Item
* Log
* MediaApp
* QGstStream
* Recorder
* VideoPlayer
* timeEdit

### Atendee

Es la clase que maneja el tipo básico de interviniente que va a acudir a la reunión. Consta de nombre del interviniente y un tiempo de inicio de su discurso y un tiempo final de su discurso.

En general la aplicación manejará 2 tipos de listas con este tipo de objetos.

#### Lista básica

Una lista básica que contiene la última aparición de cada interviniente en cuyo objeto (de cada interviniente) se guarda el último tiempo inicial y el último tiempo final de su discurso.

#### Lista extendida

La lista extendida contendrá todas las intervenciones de todos los intervinientes, pudiéndose repetir el nombre del mismo interviniente en diferentes objetos que compongan la lista pero teniendo cada una de las apariciones un tiempo inicial y un tiempo final distinto.

### Item

En esta clase se almacenarán los datos relativos a cada uno de los temas tratados en la intervención. Consta del nombre de la intervención y un tiempo inicial y un tiempo final de la intervención.

En general la aplicación manejará 2 tipos de listas con este tipo de objetos.

#### Lista básica

Una lista básica que contiene la única aparición de cada tema tratado en cuyo objeto (de cada interviniente) se guarda el último tiempo inicial y el último tiempo final de su discurso.

#### Lista extendida

La lista extendida contendrá todas las intervenciones de todos los temas tratados , pudiéndose repetir el nombre del mismo tema en diferentes objetos que compongan la lista pero teniendo cada una de las apariciones un tiempo inicial y un tiempo final distinto.

### Configurator

Es la clase que gestiona la pantalla inicial de la aplicación, en ella se puede elegir y añadir los puntos que se tratarán en la reunión, los intervinientes, la descripción, fecha y hora. También se podrá elegir el directorio en el cual se grabará el resultado (audio/video y xml descriptivo) de la reunión.

Su configuración gráfica se puede editar en el fichero configurator.ui.

Esta clase llamará a la clase *Recorder* cuando el usuario haga *click* en el botón *Start Recording*.

### Recorder

Es la clase que gestiona la grabación de una sesión, recibe como parámetros de entrada el nombre de la sesión,fecha, *path* donde hay que guardar el contenido generado, etc. Esta clase se encargará de la comunicación de la GUI con el motor de grabación (GStreamer) y con el sistema de grabado de datos en fichero (log.xml)

La clase carga los *Atendees* y los *Items* existentes y los muestra en forma de botón con los que el usuario podrá actuar.
Cada vez que se actúe en uno de ellos se guardará el tiempo indicando si es tiempo inicial o tiempo final de su intervención y se guardarán estos tiempos junto con su nombre el fichero de *log*.

Cuando el usuario haya parado la grabación y haya hecho *click* en el botón *Verify* se leerá el *log* y se pasará como parámetro su contenido completo a la clase MediaApp.


### QGstStream

Es la clase que se encarga de la grabación de la sesión, recibe diferentes parámetros y  genera un contenido de audio o de video/audio en un directorio concreto dependiendo de los parámetros de entrada.

Es la clase que conecta GStreamer con Qt.

### MediaApp 

Es la clase encargada de mostrar el contenido grabado con anterioridad. Su interfaz gráfica se genera completamente de manera programática. La clase lee los *items* y *atendees* recibidos y genera un interfaz donde se pueden editar sus tiempos.

También se carga un objeto VideoPlayer que contiene el vídeo/audio que va a ser verificado.

Los tiempos de cada elemento sólo se pueden editar si el elemento en cuestión se encuentra en el uso de la palabra en ese momento. Para hacerlo hay que hacer *click* en el botón *pause* y editar el contenido que se requiera dándole al botón *enter* cuando se dé por finalizada la edición.


### VideoPlayer

Es la clase encargada de la reproducción del video, recibe la *url* del vídeo y maneja todos los elementos relativos a la reproducción del vídeo, botones *play* y pause, avance, stop, volumen, etc...

Se ha utilizado el motor multimedia de Qt para facilitar la portabilidad. 


### Log

La clase encargada de escribir el *log* de la sesión.

## Formularios

La aplicación consta de 3 pantallas interactivas.

* Configuración -> formulario *configurator.ui*
* Grabación y anotación ->  formulario *recorder.ui*
* Pantalla de visualización y edición -> generada programáticamente (clase MediaApp)


# Instrucciones de desarrollo 

## Linux

### Instalador qt

* [http://download.qt.io/official_releases/online_installers/qt-unified-linux-x64-online.run](http://download.qt.io/official_releases/online_installers/qt-unified-linux-x64-online.run)

### Dependencias de gstreamer

* libgstreamer-plugins-bad1.0-dev
* libgstreamer-plugins-base1.0-dev
* libgstreamer1.0-dev
* gstreamer1.0-plugins-good
* gstreamer1.0-plugins-bad
* gstreamer1.0-plugins-ugly


* Instalar las dependencias de gstreamer
* clonar el repositorio 
* Instalar el SDK de Qt y Qt Creator
	* Instalar Qt 5.10 completo 
* Importar proyecto
	* File->Open file or project-> abrir bideoakta.pro
* Configurar proyecto
	* Barra vertical izquierda ->Projects
	* Configure project
* Una vez configurado ejecutarlo con el run (flecha verde grande abajo a la izquierda)
* Ficheros de ejemplo en tools
	* politicos.csv
	* acta.csv

	![Configurar Proyecto](images/project.png)

### Instalador linux

En la carpeta *tools/linux_installer* se puede encontrar un archivo con los pasos a seguir para la creación del instalador/ejecutable.


## Windows

* Instalar las dependencias de GStreamer
    * [https://gstreamer.freedesktop.org/data/pkg/windows/1.8.0/gstreamer-1.0-x86_64-1.8.0.msi](https://gstreamer.freedesktop.org/data/pkg/windows/1.8.0/gstreamer-1.0-x86_64-1.8.0.msi)
    * [https://gstreamer.freedesktop.org/data/pkg/windows/1.8.0/gstreamer-1.0-devel-x86_64-1.8.0.msi](https://gstreamer.freedesktop.org/data/pkg/windows/1.8.0/gstreamer-1.0-devel-x86_64-1.8.0.msi)
    
* Instalación de Visual Studio Community 
    * [https://www.visualstudio.com/downloads/](https://www.visualstudio.com/downloads/)
    * Instalar *Desktop development with C++*
* Instalación K-lite video plugins [https://www.codecguide.com/download_k-lite_codec_pack_basic.htm](https://www.codecguide.com/download_k-lite_codec_pack_basic.htm)
* Instalación de Qt
    * [https://info.qt.io/download-qt-for-application-development](https://info.qt.io/download-qt-for-application-development) Versión Open Source
    * Instalación Qt 5.10
        * Instalar Tools
        * Instalar las dependencias de msvc2017 para 64 bits
        * Qt Charts
        * Qt Data Visualization
        * Qt Purchasing
        * Qt Virtual Keyboard
        * Qt WebEngine
        * Qt Network Auth
        * Qt Remote Objects
        * Qt Speech
        * Qt Script
* Descargar el proyecto
* Importar proyecto
	* File->Open file or project-> abrir bideoakta.pro
* Configurar proyecto
	* Barra vertical izquierda ->Projects
	* Configure project
* Una vez configurado ejectutarlo con el run (flecha verde grande abajo a la izquierda)
* Ficheros de ejemplo en tools
	* politicos.csv
	* acta.csv

### Creación instalador

Una vez realizada la compilación del proyecto y comprobado que el sistema funciona correctamente será necesario crear un instalador para que despliegue el contenido necesario.

### Dependencias de Qt
Para ello necesitaremos instalar varias dependencias en el equipo del usuario:

* Qt 5.10
* GStreamer

Dado que el instalador de Qt es bastante grande y complejo para el usuario final optaremos por añadir las dependencias necesarias al instalador directamente en vez de darle el instalador de Qt completo al usuario. Para ello haremos uso del comando *windeployqt.exe* que nos proporciona el entorno de desarrollo de Qt.
Este comando analizará nuestra aplicación y copiará todas las dependencias de Qt necesarias para que la aplicación funcione correctamente sin necesidad de instalar ningún extra.

Para usarla es necesario abrir un terminal y desde donde se encuentre el SDK de Qt ejecutar:

```
$ windeployqt.exe <path_nuestra_aplicacion_compilada>
```
Suponiendo que tengamos nuestro proyecto en *Documents\bideoakta* tendremos que ir al directorio *C:\Qt\5.9.1\msvc2017_64\bin* y ejecutar un comando tal que:

```
$windeployqt.exe C:\Users\user\Documents\bideoakta\build-qt5mini-Desktop_Qt_5_9_1_MSVC2017_64bit-Release\release
```

En el *path* de nuestra aplicación compilada podremos encontrar todas las dependencias necesarias para agregar al instalador:

* bideoakta.exe
* diferentes dll
* directorios
    * translations 
    * playlistformats
    * audio
    * bearer
    * iconengines
    * imageformats
    * mediaservice
    * platforms

   
Copiamos todo ese contenido al directorio *app* del instalador (tools/windows_installer/app)


### Creación del instalador


Para crear el instalador utilizaremos Nsis [http://nsis.sourceforge.net/Main_Page](http://nsis.sourceforge.net/Main_Page). En el directorio windows_installer tenemos un ejemplo (bideoakta.nsi) del archivo de configuración del instalador. Sus principales partes son:

* Section -Prerequisites
    * Adjunta las dependencias al instalador y las ejecuta para que el usuario las instale
* Section -copy
    * Copia el contenido de la aplicación y sus dll al directorio seleccionado
    * Copia el uninstaller
* Section -postinstall
    * Crea enlaces a la aplicación
* Section updatePath
    * Añade Gstreamer al Path de Windows
* Section Uninstall
    * Crea el desinstalador de la aplicación

Para poder crear el instalador será necesario ejecutar la aplicación NSis abriendo el fichero bideoakta.nsi que contiene las instrucciones necesarias para crearlo.

* Compile NSI script
* Load script
* Esperar



## Mac OS X

* Instalar homebrew ([https://brew.sh/](https://brew.sh/))
    * xcode-select --install
    * ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"
* Instalar dependencias de gstreamer
    * brew install lame gstreamer gst-libav gst-plugins-bad gat-plugins-good gst-plugins-base
    * brew install gst-plugins-ugly --with-lame
* Instalar dependencias de qt (Actualmente se instalará qt 5.9.1)
    * brew install qt
* Descargar el proyecto 
* Compilar el proyecto
    * /usr/local/Cellar/qt/5.9.1/bin/qmake bideoakta.pro
    * make
* Ejecutar la aplicación
    
    * doble click en bideoakta o 
    * cd bideoakta.app
    * cd Content
    * cd MacOS
    * ./bideoakta

### Despliegue e instalación

Para usar la aplicación en MAC hay que seguir 3 pasos:

* Crear un archivo desplegable (dmg)
* Instalar las dependencias en la máquina destino


Para crear un desplegable de nuestra aplicación sólo tendremos que ejecutar el comando
```
sudo /usr/local/Cellar/qt/5.9.1/bin/macdeployqt bideoakta.app -dmg
```

y obtendremos un dmg con nuestra aplicación contenida y lista para ejecutar en los equipos que contengan las dependencias necesarias.

En el directorio *tools/mac_installer* se encuentra un script install.sh que instalará las dependencias necesarias para que se pueda ejecutar la aplicación bideoakta.


### Notas

En MAC, si no hay conectada una entrada de audio la aplicación no genera un archivo de video o audio válido y la aplicación se bloquea.

## Documentación

La documentación de doxygen puede generarse de forma automática al lanzar el comando doxygen contra el fichero Doxyfile de este directorio. La documentación se genera en un directorio doc.



